/**
 *
 *	OneCast Talent Application Form JS
 *
 */

$('#dob').datepicker({maxDate:'today',changeYear:true,yearRange:'c-100:c'});

mediaUpload('fileupload', 'talent', 'upload');

function mediaUploadPost(data)
	{
	if(data.success)
		{
		displayResponse(data.success, 'success');
		if(data.photo)
			{
			$('#photofile').val(data.photo);
			$('#img-row').html('<img src="/_media/apps/'+data.photo+'" class="app-img col-xs-6 col-xs-offset-3" title="Profile Photo" />').slideDown(350);
			$('#submit-row').slideDown(350);
			$('#btn-msg').slideUp(350);
			}
		}
	else if(data.error)
		{
		displayResponse(data.error, 'error');
		$('#submit-row, #img-row').slideUp(350);
		}
	else
		{
		displayResponse('An unknown error occurred.', 'error');
		$('#submit-row, #img-row').slideUp(350);
		}
	}

$('.submit-form').on('click', function(){
	////////////////////////////////////////////
	$('#loading').fadeIn(350);
	////////////////////////////////////////////
	$.ajax({
		type: 'POST',
		url: '/request/talent/apply',
		data: $('#application-form').serializeArray(),
		}).done(function(data){
		$('#loading').fadeOut(350);
		if(data.success)
			{
			$('#application-form').fadeOut(350,0,function(){
				$('#application-form').html('<p class="bg-brg-green col-xs-12 lh-30 txt-white alg-cr">'+data.success+'</p>').fadeIn(350);
				});
			}
		else if(data.error)
			{
			displayResponse(data.error, 'error');	
			}
		else
			{
			displayResponse('An unknown error occurred. Please contact us via our contact form if the issue continues.', 'error');	
			}
		});
	////////////////////////////////////////////	
	});
