//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// Common jQuery Init File


////////////////////////////////////////////
// Global JS Variables
var hasmce = 1;

resizeCore();
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// Page Loading Fade Out / Page Fade In
$(window).bind('load', function(){
	////////////////////////////////////////////
	$('#loading').fadeOut(250);
	$('#toolbar, #page').delay(250).fadeIn(250);
	////////////////////////////////////////////
	displayLoadMessage();
	});

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// Page Functions	
	
$(document).ready(function() {


$('body').on('click', '#tgl-mob-menu', function(){
	
	if($(this).attr('menu-tgl')=='0')
		{
		$(this).attr('menu-tgl', '1');
		$('#left-menu').animate({'left':'0px'});
		}
	else
		{
		$(this).attr('menu-tgl', '0');
		$('#left-menu').animate({'left':'-50%'});	
		}
	
	});

////////////////////////////////////////////
// Menu Hovering
$('.menu-itm').hoverIntent({
	over: function(){
		$(this).animate({'width':'150px'});
		$(this).children('.menu-lbl').animate({'margin-left':'0px'});
		}, 
	timeout: 250, 
	out: function(){
		$(this).animate({'width':'50px'});
		$(this).children('.menu-lbl').animate({'margin-left':'-150px'});
		}
	});


////////////////////////////////////////////
// Alerts Fade Out
$('.alertWrapper').delay(4000).slideUp();


////////////////////////////////////////////
// AJAX Form Processing
$(document).on('click', '.tog-help', function(){$(this).parent().children('.tog-helper').slideToggle(250)});




//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// Tab Handling

$(document).on('click', '.tab', function(){
	
	var mytab = $(this);
	var myrel = $(this).attr('tab-id');
	
	if(mytab.hasClass('active')===false)
		{
		//$('#form').scroller('destroy');
		$('.group').fadeOut(250);
		$('.tab').removeClass('active');
		mytab.addClass('active');
		$('#'+myrel).delay(250).fadeIn(250,0, function(){
			//$('#form').scroller();
			});
		}
	
	
	});

$(document).on('click', '.tab-emu', function(){
	var mytab = $(this).attr('tab-emu');
	$('.tab').each(function(){
		if($(this).attr('tab-id')==mytab)
			{$(this).click()}
		});
});


////////////////////////////////////////////
// Tab Keyboard Controls
$(document).on('keydown', function(e){
	var keycode = (e.keyCode ? e.keyCode : (e.which ? e.which : e.charCode));
	if(e.ctrlKey && keycode==37 || e.ctrlKey && keycode==39)
		{
		var curtab = $('.tab.active');
		var newtab = '';
		if(keycode==37)
			{
			newtab = $('.tab.active').prev('.tab');
			if(newtab.length==''){newtab = $('.tab').last();}
			}
		else
			{
			newtab = $('.tab.active').next('.tab');	
			if(newtab.length==''){newtab = $('.tab').first();}
			}
		if(newtab.length > 0){newtab.click()}
		return false;
		}		 
	});





//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// AJAX Processing


////////////////////////////////////////////
// AJAX Form Processing
$('.tool-save').on('click', function(){
	////////////////////////////////////////////
	
	showLoader();
	ajaxPreActions();
	////////////////////////////////////////////
	if(hasmce==2){tinymce.triggerSave();}
	////////////////////////////////////////////
	$('#loading').show();
	////////////////////////////////////////////
	var index 		= $('#index').attr('name');
	var process 	= $('#form').attr('my-process');
	var action 		= $('#form').attr('my-action')
	var linkout 	= $('#form').attr('action');
	var postdata 	= ($('#form').serializeArray());
	////////////////////////////////////////////
	$.ajax({
		type: 'POST',
		url: '/ajax/'+process+'/'+action,
		data: postdata,
		}).done(function(data){
		ajaxPostActions(data, linkout);	
		});
	////////////////////////////////////////////	
	});

$('.tool-func').on('click', function(){
	////////////////////////////////////////////
	
	showLoader();
	ajaxPreActions();
	////////////////////////////////////////////
	if(hasmce==2){tinymce.triggerSave();}
	////////////////////////////////////////////
	$('#loading').show();
	////////////////////////////////////////////
	var process 	= $(this).attr('my-process');
	var action 		= $(this).attr('my-action')
	var postdata 	= ($('#form').serializeArray());
	////////////////////////////////////////////
	$.ajax({
		type: 'POST',
		url: '/ajax/'+process+'/'+action,
		data: postdata,
		}).done(function(data){
		ajaxPostActions(data, null);	
		});
	////////////////////////////////////////////	
	});


////////////////////////////////////////////
// Form Submit on Enter
$('.input').not('.input-login, .input-search').bind('keydown', function(event){
	var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
	if(keycode == 13){$('.tool-save').click();return false;} 
	else{return true;};
	});



});

function loadList()
	{
			
	}

function loadForm()
	{
		
	}

function ajaxPreActions()
	{
	// Placeholder	
	}

function ajaxPostActions(data, linkout)
	{
	//$('#form').scroller();
	if(data.error)
		{
		displayResponse(data.error, 'error');
		}
	else if(data.success)
		{
		if(linkout != null)
			{
			window.location.replace(linkout);
			}
		else
			{
			if(data.newid)
				{
				$('#index').val(data.newid);
				$('.loadInlineForm').slideDown(250);
				$('.tab-hdn').fadeIn(250,0,function(){$('.tab-hdn').removeClass('tab-hdn')});
				$('.jsFunc').attr('id', data.newid).slideDown(250);
				$('.funcLink').each(function(){
					var cururl = $(this).attr('href');
					$(this).attr('href', cururl+''+data.newid).slideDown(250);
					});
				}				
			displayResponse(data.success, 'success');
			
			formPostUpdate(data)
			}
		}	
	}

function showLoader()
	{
	$('#loading').fadeIn(250);	
	}

// Output Message for Response
function displayResponse(message, type)
	{
	switch(type)
		{
		case 'error':
		var alertDisplay = '<div class="alert alert-error">'+ message +'</div>';
		break;
		case 'success':
		var alertDisplay = '<div class="alert alert-success">'+ message +'</div>';
		break;
		case 'unknown':
		var alertDisplay = '<div class="alert alert-warning">'+ message +'</div>';
		break;
		}
	
	$('body').append(alertDisplay);
	var movement = $('.alert').width();
	$('.alert').animate({'right':'0px'},350).delay(4000).animate({'right':'-'+movement+'px'},350,0,function(){$('.alert').remove()});
	
	$('#loading').delay(250).fadeOut(250);
	}

function displayLoadMessage()
	{
	if($('.alert').length > 0)
		{
		var movement = $('.alert').width();
		$('.alert').animate({'right':'0px'},350).delay(4000).animate({'right':'-'+movement+'px'},350,0,function(){$('.alert').remove()});
		$('#loading').delay(250).fadeOut(250);	
		}
	}


function formPostUpdate(result)
	{
	// Placeholder for use in individual includes to run script after AJAX POST
	}


function resizeCore()
	{
	$(document).on('resize', function(){
		
		
		if($('body').width() >= 768)
			{
			alert($('body').width());
			$('#tgl-mob-menu').attr('menu-tgl', '0');
			$('#left-menu').css('left','0px');
			}
		
		});
	}

// Format as Currency with 2 decimal places and commas separators
function formatAmount(fld)
	{
	if($.isNumeric($(fld).val()))
		{
		$(fld).val(parseFloat($(fld).val()).toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ","));
		}
	}


// Quick loader for autocomplete
function quickComplete(searchid, type, fieldid, extra)
	{
	if(extra!='')
		{
		$('#'+searchid).autocomplete({
			source: function(request, response) {
				$.ajax({
					url: '/ajax/'+ type +'/autocomplete',
					dataType: "json",
					data: {term : request.term, extra: $('#'+extra).val()},
					success: function(data) {response(data);}
				});
			},
			minLength: 2,
			select: function( event, ui ) {
					$(this).val(ui.item.value);
					if(fieldid!=''){$('#'+fieldid).val( ui.item.id );}
					quickCompleteUpdate(ui.item);
					return false;
			}});
		}
	else
		{
		$('#'+searchid).autocomplete({
			source: function(request, response) {
				$.ajax({
					url: '/ajax/'+ type +'/autocomplete',
					dataType: "json",
					data: {term : request.term},
					success: function(data) {response(data);}
				});
			},
			minLength: 2,
			select: function( event, ui ) {
					$(this).val(ui.item.value);
					if(fieldid!=''){$('#'+fieldid).val( ui.item.id );}
					quickCompleteUpdate(ui.item);
					return false;
			}});
		}

	$('#'+searchid).on('change', function(){if($(this).val()=='' || $(this).val()==null){$('#'+fieldid).val('')}});	
	}

function quickCompleteUpdate(selected)
	{
		
	}

// Quick loader for suburbs autocomplete
function suburbAutocomplete(suburb, sbid, state, postcode)
	{
	suburb 		= suburb || 'suburbname';
	sbid 		= sbid || 'sbid';
	state 		= state || 'suburbstate';
	postcode 	= postcode || 'suburbpostcode';
	
	$('#'+suburb).autocomplete({
	source: function(request, response) {
		$.ajax({
			url: '/ajax/suburb/autocomplete',
			dataType: "json",
			data: {term : request.term},
			success: function(data) {response(data);}
		});
	},
	minLength: 2,
	select: function( event, ui ) {
			$('#'+suburb).val(ui.item.value);
			$('#'+sbid).val( ui.item.id );
			$('#'+state).val( ui.item.state );
			$('#'+postcode).val( ui.item.pcode);
			
			return false;
	}});
	
	$('#'+suburb).on('change', function(){
		
		if($(this).val()=='' || $(this).val()==null){
			$('#'+sbid+', #'+state+', #'+postcode).val('')			
			}
		
		});		
	}


// Quick loader for TinyMCE
function tinyMCELoader(fieldid)
	{
	hasmce = 2;
	tinymce.init({
		mode : "textareas",
		selector: "#"+fieldid,
		menubar : false,
		theme: "modern",
		width:940,
		height:400,
		link_title: true,
		document_base_url:'/',
		hidden_input: false,
		convert_urls: false,
		relative_urls: false,
		content_css : "/_theme/_admin/css/editor.css?" + new Date().getTime(),
		plugins: [
			"advlist autolink lists link image charmap print preview hr anchor pagebreak",
			"searchreplace wordcount visualblocks visualchars code fullscreen",
			"insertdatetime media nonbreaking save table contextmenu directionality",
			"emoticons template paste textcolor colorpicker textpattern"
		],
		// Toolbar
		toolbar1: "undo redo removeformat | styleselect | fontsizeselect | bold italic underline | alignleft aligncenter alignright alignjustify bullist numlist | outdent indent | link image media | code",
		
		// Fonts / Styles
		fontsize_formats: "10px 12px 14px 16px 18px 22px",
		
		style_formats: [
			{title: "Text Colours", items: [
				
				{title: 'Black Text', inline: 'span', classes: 'txt-black'},
				
				{title: 'SMEWS Blue', inline: 'span', classes: 'txt-blue'},
				{title: 'SMEWS Light Blue', inline: 'span', classes: 'txt-lgt-blue'},
				{title: 'SMEWS Dark Blue', inline: 'span', classes: 'txt-drk-blue'},
				{title: 'SMEWS Very Dark Blue', inline: 'span', classes: 'txt-vdrk-blue'},
				{title: 'SMEWS Blue Grey', inline: 'span', classes: 'txt-blue-grey'},
				{title: 'SMEWS Grey Blue', inline: 'span', classes: 'txt-grey-blue'},
				
				{title: 'SMEWS Pink', inline: 'span', classes: 'txt-pink'},
				{title: 'SMEWS Pastel Red', inline: 'span', classes: 'txt-ple-red'},
				{title: 'SMEWS Red', inline: 'span', classes: 'txt-red'},
				
				{title: 'SMEWS Green', inline: 'span', classes: 'txt-green'},
				{title: 'SMEWS Light Green', inline: 'span', classes: 'txt-lgt-green'},
				{title: 'SMEWS Bright Breen', inline: 'span', classes: 'txt-brg-green'},
				
				{title: 'SMEWS Yellow', inline: 'span', classes: 'txt-yellow'},
				{title: 'SMEWS Canary', inline: 'span', classes: 'txt-can-yellow'},
				{title: 'SMEWS Tan', inline: 'span', classes: 'txt-tan'},
				
				{title: 'SMEWS Dark Grey', inline: 'span', classes: 'txt-drk-grey'},
				{title: 'SMEWS Grey', inline: 'span', classes: 'txt-grey'},
				{title: 'SMEWS Mid Grey', inline: 'span', classes: 'txt-mid-grey'},
				{title: 'SMEWS Light Grey', inline: 'span', classes: 'txt-lgt-grey'},
				
				{title: 'SMEWS White', inline: 'span', classes: 'txt-white'},
				{title: 'SMEWS Off White', inline: 'span', classes: 'txt-off-white'},
				
				{title: 'Code', inline: 'code'}
				
			]},
			{title: "Text Hover Colours", items: [
				
				{title: 'Black Text', inline: 'span', classes: 'txt-black'},
				
				{title: 'SMEWS Blue', inline: 'span', classes: 'txt-blue-hover'},
				{title: 'SMEWS Light Blue', inline: 'span', classes: 'txt-lgt-blue-hover'},
				{title: 'SMEWS Dark Blue', inline: 'span', classes: 'txt-drk-blue-hover'},
				{title: 'SMEWS Very Dark Blue', inline: 'span', classes: 'txt-vdrk-blue-hover'},
				{title: 'SMEWS Blue Grey', inline: 'span', classes: 'txt-blue-grey-hover'},
				{title: 'SMEWS Grey Blue', inline: 'span', classes: 'txt-grey-blue-hover'},
				
				{title: 'SMEWS Pink', inline: 'span', classes: 'txt-pink-hover'},
				{title: 'SMEWS Pastel Red', inline: 'span', classes: 'txt-ple-red-hover'},
				{title: 'SMEWS Red', inline: 'span', classes: 'txt-red-hover'},
				
				{title: 'SMEWS Green', inline: 'span', classes: 'txt-green-hover'},
				{title: 'SMEWS Light Green', inline: 'span', classes: 'txt-lgt-green-hover'},
				{title: 'SMEWS Bright Breen', inline: 'span', classes: 'txt-brg-green-hover'},
				
				{title: 'SMEWS Yellow', inline: 'span', classes: 'txt-yellow-hover'},
				{title: 'SMEWS Canary', inline: 'span', classes: 'txt-can-yellow-hover'},
				{title: 'SMEWS Tan', inline: 'span', classes: 'txt-tan-hover'},
				
				{title: 'SMEWS Dark Grey', inline: 'span', classes: 'txt-drk-grey-hover'},
				{title: 'SMEWS Grey', inline: 'span', classes: 'txt-grey-hover'},
				{title: 'SMEWS Mid Grey', inline: 'span', classes: 'txt-mid-grey-hover'},
				{title: 'SMEWS Light Grey', inline: 'span', classes: 'txt-lgt-grey-hover'},
				
				{title: 'SMEWS White', inline: 'span', classes: 'txt-white-hover'},
				{title: 'SMEWS Off White', inline: 'span', classes: 'txt-off-white-hover'},
				
			]},
			
			{title: "Coloured Buttons", items: [
				
				{title: 'SMEWS Blue', inline: 'span', classes: 'btn-content bg-blue'},
				{title: 'SMEWS Light Blue', inline: 'span', classes: 'btn-content bg-lgt-blue'},
				{title: 'SMEWS Dark Blue', inline: 'span', classes: 'btn-content bg-drk-blue'},
				{title: 'SMEWS Very Dark Blue', inline: 'span', classes: 'btn-content bg-vdrk-blue'},
				{title: 'SMEWS Blue Grey', inline: 'span', classes: 'btn-content bg-blue-grey'},
				{title: 'SMEWS Grey Blue', inline: 'span', classes: 'btn-content bg-grey-blue'},
				
				{title: 'SMEWS Pink', inline: 'span', classes: 'btn-content bg-pink'},
				{title: 'SMEWS Pastel Red', inline: 'span', classes: 'btn-content bg-ple-red'},
				{title: 'SMEWS Red', inline: 'span', classes: 'btn-content bg-red'},
				
				{title: 'SMEWS Green', inline: 'span', classes: 'btn-content bg-green'},
				{title: 'SMEWS Light Green', inline: 'span', classes: 'btn-content bg-lgt-green'},
				{title: 'SMEWS Bright Breen', inline: 'span', classes: 'btn-content bg-brg-green'},
				
				{title: 'SMEWS Yellow', inline: 'span', classes: 'btn-content bg-yellow'},
				{title: 'SMEWS Canary', inline: 'span', classes: 'btn-content bg-can-yellow'},
				{title: 'SMEWS Tan', inline: 'span', classes: 'btn-content bg-tan'},
				
				{title: 'SMEWS Dark Grey', inline: 'span', classes: 'btn-content bg-drk-grey'},
				{title: 'SMEWS Grey', inline: 'span', classes: 'btn-content bg-grey'},
				{title: 'SMEWS Mid Grey', inline: 'span', classes: 'btn-content bg-mid-grey'},
				{title: 'SMEWS Light Grey', inline: 'span', classes: 'btn-content bg-lgt-grey'},
				
				{title: 'SMEWS White', inline: 'span', classes: 'btn-content bg-white'},
				{title: 'SMEWS Off White', inline: 'span', classes: 'btn-content bg-off-white'},
				
			]},
			
			{title: "Coloured Buttons Hover State", items: [
				
				{title: 'SMEWS Blue', inline: 'span', classes: 'btn-content bg-blue-hover'},
				{title: 'SMEWS Light Grey', inline: 'span', classes: 'btn-content bg-lgt-blue-hover'},
				{title: 'SMEWS Dark Blue', inline: 'span', classes: 'btn-content bg-drk-blue-hover'},
				{title: 'SMEWS Very Dark Blue', inline: 'span', classes: 'btn-content bg-vdrk-blue-hover'},
				{title: 'SMEWS Blue Grey', inline: 'span', classes: 'btn-content bg-blue-grey-hover'},
				{title: 'SMEWS Grey Blue', inline: 'span', classes: 'btn-content bg-grey-blue-hover'},
				
				{title: 'SMEWS Pink', inline: 'span', classes: 'btn-content bg-pink-hover'},
				{title: 'SMEWS Pastel Red', inline: 'span', classes: 'btn-content bg-ple-red-hover'},
				{title: 'SMEWS Red', inline: 'span', classes: 'btn-content bg-red-hover'},
				
				{title: 'SMEWS Green', inline: 'span', classes: 'btn-content bg-green-hover'},
				{title: 'SMEWS Light Green', inline: 'span', classes: 'btn-content bg-lgt-green-hover'},
				{title: 'SMEWS Bright Breen', inline: 'span', classes: 'btn-content bg-brg-green-hover'},
				
				{title: 'SMEWS Yellow', inline: 'span', classes: 'btn-content bg-yellow-hover'},
				{title: 'SMEWS Canary', inline: 'span', classes: 'btn-content bg-can-yellow-hover'},
				{title: 'SMEWS Tan', inline: 'span', classes: 'btn-content bg-tan-hover'},
				
				{title: 'SMEWS Dark Grey', inline: 'span', classes: 'btn-content bg-drk-grey-hover'},
				{title: 'SMEWS Grey', inline: 'span', classes: 'btn-content bg-grey-hover'},
				{title: 'SMEWS Mid Grey', inline: 'span', classes: 'btn-content bg-mid-grey-hover'},
				{title: 'SMEWS Light Grey', inline: 'span', classes: 'btn-content bg-lgt-grey-hover'},
				
				{title: 'SMEWS White', inline: 'span', classes: 'btn-content bg-white-hover'},
				{title: 'SMEWS Off White', inline: 'span', classes: 'btn-content bg-off-white-hover'},
				
			]},
			
			{title: "Common HTML Headers", items: [
				/*{title: "Header 1 (22px)", format: "h1"},*/
				{title: "Header 2 (18px)", format: "h2"},
				{title: "Header 3 (16px)", format: "h3"}
			]}			
		],
		
		// Images
		image_list: "/ajax/online/images?get",
		image_advtab: true,
		image_class_list: [
			{title: 'None', value: ''},
			{title: 'Article Image Left', value: 'articleImage'},
			{title: 'Article Image Right', value: 'articleImageRight'}
		],
		
		// Links
		link_list: "/ajax/online/links?get",
		link_class_list: [
			
			{title: 'Txt - Black', value: 'txt-black'},
			{title: 'Txt - Blue', value: 'txt-blue'},
			{title: 'Txt - Light Blue', value: 'txt-lgt-blue'},
			{title: 'Txt - Red', value: 'txt-red'},
			{title: 'Txt - Yellow', value: 'txt-yellow'},
			{title: 'Txt - Orange', value: 'txt-orange'},
			
			{title: 'Btn - Blue with Lgt Blue Hvr', value: 'btn-content bg-blue bg-lgt-blue-hover txt-white txt-white-hover'},
			{title: 'Btn - Drk Blue with Blue Hvr', value: 'btn-content bg-drk-blue bg-blue-hover txt-white txt-white-hover'},
			{title: 'Btn - Green with Blue Hvr', value: 'btn-content bg-brg-green bg-blue-hover txt-white txt-white-hover'},				
			{title: 'Btn - Yellow with Orange Hvr', value: 'btn-content bg-yellow bg-orange-hover txt-black txt-black-hover'},
		]
	});
	}

// Quick loader for Drag and Drop Media Uploader
function mediaUpload(filefield, uploadtype)
	{
	$('#'+filefield).fileupload({
		url: '/ajax/'+ uploadtype +'/upload',
		dataType: 'json',
		dropZone: $('#'+filefield+'Dropzone'),
		send: function (e, data) {
			$('.niceDropzone').slideUp(250);
			$('.niceFileProgress').slideDown(250);
			$('#'+ filefield +', #'+ filefield +'Title').val(null);
		},
		done: function (e, data) {
		$('#'+ filefield +'Progress .niceProgressBar').css('width', '0px');
		$('.niceDropzone').slideDown(250);
		$('.niceFileProgress').slideUp(250);
		mediaUploadPost(data);				
		},
		progressall: function (e, data) {
			var progress = parseInt(data.loaded / data.total * 100, 10);
			$('#'+ filefield +'Progress .niceProgressBar').css(
				'width',
				progress + '%'
			);
		}
	})
	.prop('disabled', !$.support.fileInput)
	.parent().addClass($.support.fileInput ? undefined : 'disabled');	
	}

function mediaUploadPost(data)
	{
	// This is a placeholder function that can be overwritten 
	// inside an individual include file to have additional functionality
	
	if(data.result.success)
		{
		displayResponse(data.result.success, 'success');
		}
	else if(data.result.error)
		{
		displayResponse(data.result.error, 'error');
		}
	else
		{
		displayResponse('An unknown error occurred.', 'error');
		}
	}

function removeMedia(type, button, message, title, rows)
	{
	$('body').on('click', button, function(){
		
		$(this).addClass('active-delete');
		$('#dialog').html(message);
		
		$('#dialog').dialog({
			resizable: false,
			height:200,
			width:400,
			modal: true,
			dialogClass: 'myDialog',
			title: title,
			buttons: 
				{
				'Yes Delete': function() {
					$('#dialog').dialog('close');
					$('#loading').show();				
					var postdata = {'id':$('#index').val(), 'filename':$(button).attr('my-file')};
					
					$.ajax({
						type: 'POST',
						url: '/ajax/'+ type +'/remove',
						data: postdata,
					}).done(function(data){
						removeMediaPost(data, rows);
						});	
				},
				"Cancel": function() {
					$('#dialog').dialog("close");
				}
			}});
		});	
	}

function removeMediaPost(data, hideme)
	{
	if(data.error)
		{
		displayResponse(data.error, 'error');
		}
	else if(data.success)
		{
		$(hideme).slideUp(250,0, function(){
			$(hideme).addClass('row-hdn').attr('style', null);
			});
		displayResponse(data.success, 'success');
		$('.active-delete').removeClass('active-delete');
		}	
	}