// Upload Media File
$('#uploadMediaBtn').on('click', function(){
	$('#loading').show();
	var postdata = ($('#validateUploadMedia').serializeArray());
	$.ajax({
		type: "POST",
		url: "/ajax/validateUploadMedia",
		data: postdata,
		}).done(function(data){
		if(data.success){$('#validateUploadMedia').submit();}
		else{displayResponse(data.error, 'error');}
		});
	});


// Size Toggling
$('#setToSmall').on('click', function(){
	$('.mediaWrapper').fadeOut(250,0, function(){
		$('.mediaTool').removeClass('activeTool');
		$('#setToSmall').addClass('activeTool');
		$('.mediaWrapper').removeClass('mediaWrapperMdm').addClass('mediaWrapperSml');
		$('.mediaFile').removeClass('mediaFileMdm').addClass('mediaFileSml');
		$('.mediaWrapper').fadeIn(250);
		});
	});

$('#setToMedium').on('click', function(){
	$('.mediaWrapper').fadeOut(250,0, function(){
		$('.mediaTool').removeClass('activeTool');
		$('#setToMedium').addClass('activeTool');
		$('.mediaWrapper').removeClass('mediaWrapperSml').addClass('mediaWrapperMdm');
		$('.mediaFile').removeClass('mediaFileSml').addClass('mediaFileMdm');
		$('.mediaWrapper').fadeIn(250);
		});
	});

$('#setToLarge').on('click', function(){
	$('.mediaWrapper').fadeOut(250,0, function(){
		$('.mediaTool').removeClass('activeTool');
		$('#setToLarge').addClass('activeTool');
		$('.mediaWrapper').removeClass('mediaWrapperSml').removeClass('mediaWrapperMdm');
		$('.mediaFile').removeClass('mediaFileSml').removeClass('mediaFileMdm');
		$('.mediaWrapper').fadeIn(250);
		});
	});


// Delete File 
$('body').on('click', '.mediaDelete', function(){
	$('#loadingOnly').show();
	$('#myDialog').remove();
	
	var myfile = $(this).parent('.mediaFileTools').parent('.mediaWrapper');
	
	$('body').prepend('<div id="myDialog"><p>Are you sure you want to delete this file?</p><p class="pinkTxt">If this file is used in an article, for a banner / button or as a linkable resource, it will be removed and an error may appear on the page!</p></div>');
	
	$("#myDialog").dialog({
		resizable: false,
		height:180,
		modal: true,
		dialogClass: 'myDialog',
		title: 'Confirm Delete',
		buttons: {
			"Yes Delete": function() {
				$(this).dialog("close");
				$('#loadingOnly').fadeOut();
				$('#loading').show();
				$.ajax({
					type: "POST",
					url: "/ajax/deleteMediaFile",
					data: {'filename':myfile.attr('my-file'), 'filepath':myfile.attr('my-path')},
				}).done(function(data){
					if(data.error)
						{
						displayResponse(data.error, 'error');
						}
					else if(data.success)
						{
						displayResponse(data.success, 'success');
						myfile.fadeOut(250);
						}
					});	
			},
			"Cancel": function() {
				$(this).dialog("close");
				$('#loadingOnly').fadeOut();
			}
		}
		});
	});


// Media Nav
$('body').on('click', '.mediaNavOption', function(){
	
	var thisdir = $(this);
	
	$.ajax({
		type: "POST",
		url: "/ajax/getFileList",
		data: {'directory':thisdir.attr('my-path')},
	}).done(function(data){
		if(data.error)
			{
			displayResponse(data.error, 'error');
			}
		else if(data.success)
			{
			$('#directory').val(thisdir.attr('my-path'));
			$('.mediaNavOption').removeClass('mediaNavActive');
			thisdir.addClass('mediaNavActive');
			$('#mediaFiles').fadeOut(250,0,function(){
				$('#mediaFiles').html(data.files).after(function() {
                    $('#mediaFiles').fadeIn(250);
                	});
				});;
			}
		});	
	});


// Load Image into Cropper
$('body').on('click', '.mediaCrop', function(){
	
	$('#imageBeingCropped').attr('id',null);
	var mymedia = $(this).parent('.mediaFileTools').parent('.mediaWrapper');
	
	
	var imgcrop = '<img src="/_media/'+mymedia.attr('my-path')+'/'+mymedia.attr('my-file')+'" my-file="'+mymedia.attr('my-file')+'" my-path="'+mymedia.attr('my-path')+'" id="imgToCrop" alt="Image To Crop" />';
	
	$('#imageCropper').html(imgcrop).after(function(){
		mymedia.attr('id', 'imageBeingCropped');
		$('.imageCropper').slideDown(250);
		loadCropper();
		});
	});

// Crop Image
$('body').on('click', '#cropImageBtn', function(){
	
	$('#loadingOnly').show();
	$('#myDialog').remove();
	
	$('body').prepend('<div id="myDialog"><p>Are you sure you want to crop this image?</p></div>');
		
	$("#myDialog").dialog({
		resizable: false,
		height:180,
		modal: true,
		dialogClass: 'myDialog',
		title: 'Confirm Crop',
		buttons: {
			"Yes Crop": function() {
				$(this).dialog("close");
				$('#loadingOnly').hide();
				$('#loading').show();				
				var xc = $('#xc').val();
				var yc = $('#yc').val();
				var wc = $('#wc').val();
				var hc = $('#hc').val();
				var myfile = $('#imgToCrop').attr('my-file');
				var mypath = $('#imgToCrop').attr('my-path');
				
				$.ajax({
					type: "POST",
					url: "/ajax/cropImage",
					data: {filename:myfile, filepath:mypath, xc:xc, yc:yc, wc:wc, hc:hc},
				}).done(function(data){
					$('#loading').delay(250).fadeOut(250);
					if(data.error)
						{
						displayResponse(data.error, 'error');
						}
					else if(data.success)
						{
						$('#imageBeingCropped').fadeOut(250,0,function(){
							$('#imageBeingCropped').children('.mediaFileView').children('.mediaImage').attr('src','/_media/'+mypath+'/'+myfile+'?'+Math.random());
							$('#imageBeingCropped').fadeIn(250);
							});
						$('.imageCropper').slideUp(250,0,function(){
							$('#imgToCrop').remove();
							});
						}
					});	
			},
			"Cancel": function() {
				$(this).dialog("close");
			}
		}});
	});


$('body').on('change', '.customSize', function(){
	
	if($('#useratio').val()==1)
		{
		if($('#minwidth').val()!='')
			{
			$('#minheight').val(parseFloat($('#minwidth').val()/$('#ratio').val()));	
			}
		}
	
	loadCropper();
	});


function loadCropper()
	{
	if(myjcrop!=null){myjcrop.destroy();}
	
	var myjcrop = '';
	
	if($('#ratio').val()!='0')
		{
		opts = 'ratio';
		$('#imgToCrop').Jcrop({
			aspectRatio: $('#ratio').val(),
			minSize: [0,0],
			onSelect: updateCoords,
			bgColor:'white'
			},
			function(){
			myjcrop = this
			});	
		}
	else
		{
		opts = 'size';
		$('#imgToCrop').Jcrop({
			aspectRatio: false,
			minSize: [$('#minwidth').val(),$('#minheight').val()],
			onSelect: updateCoords,
			bgColor:'white'
			},
			function(){
			myjcrop = this
			});	
		}
	}
	
function updateCoords(c){$('#xc').val(c.x);$('#yc').val(c.y);$('#wc').val(c.w);$('#hc').val(c.h);}

function extraSelectChecks()
	{
	if($('#ratioselect').val()!='')
		{
		switch($('#ratioselect').val())
			{
			case 'banner':
			$('#ratio').val('0');
			$('#minwidth').val('1100');
			$('#minheight').val('400');
			break;
			case 'bannerratio':
			$('#ratio').val('2.75');
			$('#minwidth').val('0');
			$('#minheight').val('0');
			break;	
			}
		}
	else
		{
		$('#ratio').val('0');	
		$('#minwidth').val('0');
		$('#minheight').val('0');
		}
	loadCropper();
	}



$('#fileupload').fileupload({
		url: '/ajax/uploadMediaFile',
		dataType: 'json',
		dropZone: $('#dropzone'),
		send: function (e, data) {
			$('.progress-completed').remove();
			$('#filetitle, #fileupload').val(null);
		},
		done: function (e, data) {
		$('#progress .progress-bar').css('width', '0px');
		if(data.result.success)
			{
			$('#mediaFiles').prepend(data.result.file);
			displayResponse('success', 'Your file has been uploaded');
			}
		else
			{
			displayResponse('error', 'There was an error uploading the file.');	
			}
		},
		progressall: function (e, data) {
			var progress = parseInt(data.loaded / data.total * 100, 10);
			$('#progress .progress-bar').css(
				'width',
				progress + '%'
			);
		}
	})
	.prop('disabled', !$.support.fileInput)
	.parent().addClass($.support.fileInput ? undefined : 'disabled');
