// Common jQuery Init
var hasmce = 1;

$(document).ready(function() {

$(window).bind('load', function(){
	$('#contentLoading').fadeOut(250);
	$('#contentWrapper').delay(250).fadeIn(250);
	});

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// Window Sizing
resizeCore();
$(window).on('resize', function(){
	resizeCore();
	});
	
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// Page Loading and Resizing
$('.alertWrapper').delay(4000).slideUp();

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// Menu Hover SlideOut
var config = {over: makeTall, timeout: 250, out: makeShort};
$('.menuItem').hoverIntent(config);
$('.subMenuItem').hoverIntent(config);


//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// AJAX Processing
$('.toolBarSubmit').click(function(){
	
	if($(this).attr('rel'))
		{
		var btn = $(this).attr('rel');	
		$('#'+btn).click();
		}
	else
		{
		$('.ajaxFormRequest:first').click();
		}			
	});

// Ajax Form Submit
$('.ajaxFormRequest').on('click', (function(){
	ajaxPreActions();
	if(hasmce==2){tinymce.triggerSave();}
	$('#loading').show();
	var request = $(this).attr('my-rel');
	var datarole = $(this).attr('my-id');
	var linkout = $('#'+request).attr('action');
	var postdata = {};
	var postdata = ($('#'+request).serializeArray());
	
	$.ajax({
		type: "POST",
		url: "/ajax/"+request,
		data: postdata,
		}).done(function(data){
		ajaxPostActions(data, datarole, linkout);	
		});	
	}));

// Ajax Update Active Status
$('.activeColumn').on('click' ,function(){
	
	var status = $(this).attr('act-state');
	var table = $(this).attr('act-table');
	var col = $(this).attr('act-col');
	var idx = $(this).attr('act-idx');
	var id = $(this).attr('act-id');
	var chi = $(this).children('span');
	
	if($(this).attr('act-state')==1){$(this).attr('act-state', 2);}
	else{$(this).attr('act-state', 1);}
		
	$.ajax({
		type: "POST",
		url: "/ajax/activeSwitch",
		data: {'index': idx, 'table': table, 'id': id, 'col': col, 'active': status},
		}).done(function(data){
			
			if(data.error)
			{
			displayResponse(data.error, 'error');
			}
			else if(data.success)
			{
			if(status==1){chi.removeClass('activeIcon').addClass('inactiveIcon');}
			else{chi.removeClass('inactiveIcon').addClass('activeIcon');}
			chi.parent('p').parent('li').animate({ backgroundColor: "#daf5dc" }, 250).delay(100).animate({ backgroundColor: "transparent" }, 250);
			}
		});
	});

// AJAX Delete 
$(".toolBarDelete").click(function(){
	
	$('#contentWrapper').prepend('<div id="dialog-confirm">Are you sure you want to delete this item?</div>');
	
	$("#dialog-confirm").dialog({
		resizable: false,
		height:140,
		modal: true,
		title: 'Confirm Delete',
		buttons: {
			"Yes Delete": function() {
				$(this).dialog("close");
				$('#loading').show();				
				var deltbl 	= $(".toolBarDelete").attr('del-table');
				var delcol 	= $(".toolBarDelete").attr('del-col');
				var delid 	= $(".toolBarDelete").attr('del-id');
				var postdata = {'table':deltbl, 'column':delcol, 'id':delid};
				
				$.ajax({
					type: "POST",
					url: "/ajax/delete",
					data: postdata,
				}).done(function(data){
					if(data.error)
						{
						displayResponse(data.error, 'error');
						}
					else if(data.success)
						{
						$(':input:not(:button)').val('');
						displayResponse(data.success, 'success');
						}
					});	
			},
			"Cancel": function() {
				$(this).dialog("close");
			}
		}
		});
	});

//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////
// Form and List Functions

// Get Inline Form
$('.loadInlineForm').click(function(){
	
	var mybtn = $(this);
	var isopen = mybtn.attr('is-open');
	
	if(isopen=='1')
		{
		mybtn.attr('is-open', '2');
		$('#slideoutToolInner').fadeOut(250);
		$('#slideoutTool').delay(250).animate({'width':'0px'}, 500).html('');
		$('#contentWrapper').delay(250).animate({'right':'0px', 'top':'30px'}, 500);
		$('#contentWrapperOpen').delay(250).animate({'right':'0px', 'top':'30px'}, 500);
		}
	else
		{
		$('#loading').show();
		var request = mybtn.attr('my-rel');
		var datarole = mybtn.attr('my-id');
		var myval = $('#'+datarole).val();
		$.ajax({
			type: "POST",
			url: "/forms/"+request,
			data: {myid: myval},
		}).done(function(data){
			$('#loading').fadeOut(250);
			if(data.error)
			{
			displayResponse(data.error, 'error');
			}
			else if(data.success)
			{
			$('.loadInlineForm').attr('is-open', '2');
			mybtn.attr('is-open', '1');
			$('#slideoutToolInner').fadeOut(250);
			$('#slideoutTool').animate({'width':'300px'}, 500).delay(500).html('<div id="slideoutToolInner">'+data.output+'</div>');
			$('#slideoutToolInner').delay(750).fadeIn(250);
			$('#contentWrapper').delay(250).animate({'right':'300px', 'top':'30px'}, 500, 0, adjustFormHeight());
			$('#contentWrapperOpen').delay(250).animate({'right':'300px', 'top':'30px'}, 500, 0, adjustFormHeight());
			}	
		});	
		}
	});

// Get Pop-Up Form
$('.loadPopupForm').click(function(){
	
	var mybtn = $(this);
	
	$('#loading').show();
	var request = mybtn.attr('my-rel');
	var myval = mybtn.attr('my-val');
	$.ajax({
		type: "POST",
		url: "/forms/"+request,
		data: {myval: myval},
		}).done(function(data){
			if(data.error)
			{
			$('#loading').fadeOut(250);
			displayResponse(data.error, 'error');
			}
			else if(data.success)
			{
			$('#popupTool').html(data.output).fadeIn(250);
			$('#popupFormSidebar').fadeIn(250);
			}	
		});	
	});

// Reset Search
$('#resetSearch').click(function(){
	$('#dataListSearch').val();
	$('#dataListColumn').val();
	$(this).parent('form').submit();	
	});

// Set Reorder and Submit
$('.sortableHeader').click(function(){
	var neworder = $(this).attr('rel');
	var curorder = $('#orderby').val();
	var curordering = $('#ordering').val();
	var updated = 0;
	if(curorder==neworder)
		{
		var newordering = curordering=='ASC' ? 'DESC' : 'ASC';
		}
	else
		{
		var newordering = curordering;	
		}
	
	$('#orderby').val(neworder);
	$('#ordering').val(newordering);
	$('#searchForm').submit();
	});

// Change Listing Layout
$('.layoutFormat:not(.activeLayout)').click(function(){
	var newlayout = $(this).attr('view-rel');
	$('.layoutField').val(newlayout);
	$('#searchForm').submit();
	});

// Expand / Contract Data Groups
$('.listHeader').click(function(){
	$(this).parent('li').children('ul').slideToggle(500);
	var icon = $(this).children('.formGroupIcon');
	var iconstatus = icon.attr('rel');
	if(iconstatus=='open'){icon.attr('rel', 'closed').removeClass('minusIcon').addClass('plusIcon');}
	else{icon.attr('rel', 'open').removeClass('plusIcon').addClass('minusIcon');}
	});

// Search Button Bindings
// Input Field to Ajax Form
$(".formInput").bind("keydown", function(event){
	var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
	if(keycode == 13){$('.ajaxFormRequest:first').click();return false;} 
	else{return true;};
	});

// Search Input Field Bind
$("#dataListSearch").bind("keydown", function(event){
	var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
	if (keycode == 13){$('#searchGo').click();return false;} 
	else {return true;};
	});

// Select Field Enter Bind
$(".dataListSearch select").bind("keydown", function(event){
	var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
	if(keycode == 13){$('#searchGo').click();return false;} 
	else{return true;};
	});
	
// Escape to Reset Search
$(document).bind("keydown", function(event){
	var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
	if(keycode == 27){$('#resetSearch').click();return false;}		 
	else {return true;};
	});
	
// Escape to Close Popup
$(document).on("keydown", function(event){
	var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
	if(keycode == 27 && $('#popupTool').length > 0){$('#popupTool').fadeOut(250);$('#loading').fadeOut(250);}
	});

// Tab Controls
$('.formTab').click(function(){
	var myrel = $(this).attr('my-rel');
	var acttab = $(this).attr('act-tab');
	var myhgt = 41;
	$('.'+myrel).each(function(){myhgt += $(this).outerHeight(true);});
	
	if(acttab!=1)
		{
		$('.formRow').fadeOut(250);
		$('.formTab').removeClass('activeTab').attr('act-tab', 0);
		$(this).addClass('activeTab').attr('act-tab', 1);
		$('.'+myrel).delay(250).fadeIn(250);
		resizeCore();
		
		if($('#pagetype').length!=null)
			{
			if($('#pagetype').val()=='blog')
				{
				$('#newsCategoryRow').fadeIn(250);	
				}
			}
		}	
	});

// Check Box Toggle
$('.multiSetItem').on('click', function(){
	
	var myfld = $(this).children('.hiddenCheckbox');
	var myrel = myfld.attr('my-rel');
	
	switch(myrel)
		{
		case '1':
		$(this).removeClass('selectedItem');
		myfld.attr('my-rel','0').attr('checked', null);
		break;
		case '0':
		$(this).addClass('selectedItem');
		myfld.attr('my-rel','1').attr('checked', 'checked');
		break;	
		}
	
	});

// Fake Radio Toggle
$('.fakeRadioDisplay').click(function(){

	var field = $(this);
	var myval = field.attr('data-rel');
	
	if($('#'+myval).val()=='1')
		{
		$('#'+myval).val('2');
		field.addClass('fakeRadioNo');
		}
	else
		{
		$('#'+myval).val('1');
		field.removeClass('fakeRadioNo');	
		}
	
	});

// Fake File Input
$('.fakeFileSource').change(function(){

	var field = $(this);
	field.parent('.fakeFileWrapper').children('.fakeFileTitle').val(field.val())
	
	});

});


// Menu Hover Functions
function makeTall(){$(this).children('ul').slideDown(250);}
function makeShort(){$(this).children('ul').slideUp(250);}

function ajaxPreActions()
	{
	// Placeholder	
	}

function ajaxPostActions(data, id, linkout)
	{
	if(data.error)
		{
		displayResponse(data.error, 'error');
		}
	else if(data.success)
		{
		if(linkout != null)
			{
			window.location.replace(linkout);
			}
		else
			{
			if(data.newid)
				{
				$('#'+id).val(data.newid);
				$('.loadInlineForm').slideDown(250);
				$('.jsFunc').attr('id', data.newid).slideDown(250);
				$('.funcLink').each(function(){
					var cururl = $(this).attr('href');
					$(this).attr('href', cururl+''+data.newid).slideDown(250);
					});
				}				
			displayResponse(data.success, 'success');
			}
		}	
	}

// Output Message for Response
function displayResponse(message, type)
	{
	switch(type)
		{
		case 'error':
		var alertDisplay = '<div class="errorAlertWrapper alertWrapper"><p class="errorAlertText">'+ message +'</p></div>';
		break;
		case 'success':
		var alertDisplay = '<div class="userAlertWrapper alertWrapper"><p class="userAlertText">'+ message +'</p></div>';
		break;
		}
	
	$('body').prepend(alertDisplay);
	$('#contentWrapperOpen').prepend(alertDisplay);
	$('.alertWrapper').delay(4000).slideUp();
	$('#loading').delay(250).fadeOut(250);
	}

function disableEnter(event)
	{
	var keycode = (event.keyCode ? event.keyCode : (event.which ? event.which : event.charCode));
	if(keycode==13){return false;}else{return true;}
	}

function resizeCore()
	{
	var menuheight = $('#topBar').height();
	var content = menuheight;
	var win = $(this);
	
	$('#systemToolbar, #systemToolbarOpen').css('top', menuheight+'px');
	$('#contentWrapper, #contentWrapperOpen').css('margin-top', content+'px');
	}

function tinyMCELoader(fieldid)
	{
	hasmce = 2;
	tinymce.init({
		mode : "textareas",
		selector: "#"+fieldid,
		theme: "modern",
		plugins: [
			"advlist autolink lists link image charmap print preview hr anchor pagebreak",
			"searchreplace wordcount visualblocks visualchars code fullscreen",
			"insertdatetime media nonbreaking save table contextmenu directionality",
			"emoticons template paste textcolor colorpicker textpattern"
		],
		toolbar1: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image",
		toolbar2: "print preview media | forecolor backcolor emoticons",
		image_advtab: true,
		width:700,
		height:350,
		image_list: "/ajax/imagesList?get",
		hidden_input: false
	});
	
	
	}