<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Schema extends CI_Model {

var $type 		= '';

var $article	= '';

var $group 		= '';

var $title		= '';

var $alias 		= '';

var $created	= '';

var $published	= '';

var $author		= '';

var $image		= '';
			
var $desc		= '';

var $body		= '';

var $url		= '';

var $category	= '';

var $phone		= '';

var $email		= '';


public function init($type=NULL)
	{
	
	$this->type = $type!=NULL ? $type : $this->type;
	
	switch($this->type)
		{
		case '2':	// Product
		$this->product();
		break;
		
		default:	// Default
		case '3':	// Webpage
		$this->webpage();
		break;
		
		case '4':	// Organization
		case '5':	// LocalBusiness
		$this->business();
		break;
		
		case '8':	// Blog [Collection of Articles]
		$this->blog();
		break;
		
		case '6':	// BlogPosting [Single Article]
		$this->blogpost();
		break;
		
		case '7':	// Creative Work / Folio Item
		$this->creative();
		break;	
		}
	
	$this->page->schema = $this;
	}


/////////////////////////////////////////////////
/////////////////////////////////////////////////
// Individual Constructors

private function product()
	{
	$this->type 	= ' itemscope="" itemtype="http://schema.org/Product"';
	
	$this->article 	= '';
	
	$this->title 	= ' itemprop="name"';
	
	$this->alias 	= ' itemprop="alternateName"';
	
	$this->created 	= '';
	
	$this->published= '';
	
	$this->author 	= '';
	
	$this->image 	= ' itemprop="image"';
	
	$this->desc 	= ' itemprop="description"';
	
	$this->body 	= '';
	
	$this->url 		= ' itemprop="url"';
	
	$this->category = ' itemprop="category"';
	
	$this->phone 	= '';
	
	$this->email 	= '';
	}


private function webpage()
	{
	$this->type 	= '';
	
	$this->article 	= ' itemprop="mainContentOfPage"  itemscope="" itemtype="http://schema.org/WebPageElement"';
	
	$this->title 	= ' itemprop="name"';
	
	$this->alias 	= ' itemprop="headline"';
	
	$this->created 	= ' itemprop="lastReviewed"';
	
	$this->published= '';
	
	$this->author 	= ' itemprop="author"';
	
	$this->image 	= ' itemprop="image"';
	
	$this->desc 	= ' itemprop="description"';
	
	$this->body 	= ' itemprop="text"';
	
	$this->url 		= ' itemprop="url"';
	
	$this->category = ' itemprop="category"';
	
	$this->phone 	= '';
	
	$this->email 	= '';	
	}
	

private function business()
	{
	$this->type 	= ' itemscope="" itemtype="http://schema.org/LocalBusiness"';
	
	$this->article 	= '';
	
	$this->title 	= ' itemprop="name"';
	
	$this->alias 	= ' itemprop="alternateName"';
	
	$this->created 	= ' itemprop="foundingDate"';
	
	$this->published= '';
	
	$this->author 	= ' itemprop="legalName"';
	
	$this->image 	= ' itemprop="image"';
	
	$this->desc 	= ' itemprop="description"';
	
	$this->body 	= '';
	
	$this->url 		= ' itemprop="url"';
	
	$this->category = '';
	
	$this->phone 	= ' itemprop="telephone"';
	
	$this->email 	= ' itemprop="email"';	
	}
	

private function blog()
	{
	$this->type 	= ' itemscope="" itemtype="http://schema.org/Blog"';
	
	$this->article 	= '';
	
	$this->title 	= '';
	
	$this->alias 	= '';
	
	$this->created 	= '';
	
	$this->published= '';
	
	$this->author 	= ' itemprop="author"';
	
	$this->image 	= '';
	
	$this->desc 	= '';
	
	$this->body 	= '';
	
	$this->url 		= '';
	
	$this->category = '';	
	
	$this->phone 	= '';
	
	$this->email 	= '';
	}

private function blogpost()
	{
	$this->type 	= ' itemscope="" itemtype="http://schema.org/BlogPosting"';
	
	$this->article 	= '';
	
	$this->title 	= ' itemprop="headline"';
	
	$this->alias 	= ' itemprop="alternateName"';
	
	$this->created 	= ' itemprop="dateCreated"';
	
	$this->published= ' itemprop="datePublished"';
	
	$this->author 	= ' itemprop="author"';
	
	$this->image 	= ' itemprop="image"';
	
	$this->desc 	= ' itemprop="description"';
	
	$this->body 	= ' itemprop="articleBody"';
	
	$this->url 		= ' itemprop="url"';
	
	$this->category = ' itemprop="articleSection"';	
	
	$this->phone 	= '';
	
	$this->email 	= '';
	}


private function creative()
	{
	$this->type 	= ' itemprop="exampleOfWork"  itemscope="" itemtype="http://schema.org/CreativeWork"';
	
	$this->article 	= '';
	
	$this->title 	= ' itemprop="name"';
	
	$this->alias 	= ' itemprop="alternateName"';
	
	$this->created 	= '';
	
	$this->published= '';
	
	$this->author 	= ' itemprop="author"';
	
	$this->image 	= ' itemprop="image"';
	
	$this->desc 	= ' itemprop="description"';
	
	$this->body 	= '';
	
	$this->url 		= ' itemprop="url"';
	
	$this->category = '';
	
	$this->phone 	= '';
	
	$this->email 	= '';	
	}





/////////////////////////////////////////////////
/////////////////////////////////////////////////
// Outputs

public function type()		{if($this->type!='')		{echo $this->type;}}

public function article()	{if($this->article!='')		{echo $this->article;}}

public function title()		{if($this->title!='')		{echo $this->title;}}

public function alias()		{if($this->alias!='')		{echo $this->alias;}}

public function created()	{if($this->created!='')		{echo $this->created;}}

public function published()	{if($this->published!='')	{echo $this->published;}}

public function author()	{if($this->author!='')		{echo $this->author;}}

public function image()		{if($this->image!='')		{echo $this->image;}}

public function desc()		{if($this->desc!='')		{echo $this->desc;}}

public function body()		{if($this->body!='')		{echo $this->body;}}

public function url()		{if($this->url!='')			{echo $this->url;}}

public function category()	{if($this->category!='')	{echo $this->category;}}

public function phone()		{if($this->phone!='')		{echo $this->phone;}}

public function email()		{if($this->email!='')		{echo $this->email;}}




}
