<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Webpages extends CI_Model {

// Variables
var $buid 		= '';
var $value		= '';
var $record		= array();

// Listing and Editing URLs
var $name		= 'Webpage';
var $base 		= 'webpage/listing/';
var $link 		= 'webpage/edit/';

// Edit Folder Name
var $editor 	= 'webpage/edit';

// Table Settings
var $table 		= 'content';
var $index 		= 'coid';

var $select		= 'content.*, p.contenttitle AS parenttitle';

var $join		= array('p' => array('coid', 'pcoid'));
var $alias		= 'content AS smw_p';

var $filterby 	= 'contentactive';
var $filterlbl 	= 'Type';
var $filters	= array('1' => 'Active', '2' => 'Inactive');
var $fixed		= array();

var $orderby 	= 'contentnodel';
var $ordering 	= 'asc';

var $options	= array('content.contenttitle' => 'Content Title', 'p.contenttitle' => 'Parent Title', 'content.contentkeywords' => 'Meta Keywords', 'content.contentdescription' => 'Meta Description');

var $contenttypes 	= array('home' 		=> array(
								'title' 	=> 'Home Page',
								'default'	=> array('banners', 'buttons/above', 'article', 'blog/recent', 'buttons/below', 'blog/latest'), 
								'unique' 	=> 1
								),
							'contact' 	=> array(
								'title' 	=> 'Contact Form', 
								'default'	=> array('banners', 'buttons/above', 'article', 'form/contact', 'buttons/below'),
								'unique' 	=> 1
								),
							'article' 	=> array(
								'title' 	=> 'Webpage / Article', 
								'default'	=> array('banners', 'buttons/above', 'article', 'buttons/below'),
								'unique' 	=> 2
								),
							'blog' 		=> array(
								'title' 	=> 'News / Blog Article',
								'default'	=>  array('article', 'blog/latest', 'blog/listing'),
								'unique' 	=> 2
								),
							'portfolio'	=> array(
								'title' 	=> 'Portfolio',
								'default'	=>  array('banners', 'buttons/above', 'article', 'buttons/below', 'portfolio/folio'),
								'unique' 	=> 2
								),
							'sitemap'	=> array(
								'title' 	=> 'Sitemap', 
								'default'	=> array('banners', 'buttons/above', 'article', 'buttons/below', 'sitemap/sitemap'),
								'unique' 	=> 1
								),
							);


// Required Fields

var $required = array(	'ctid' 					=> 'You must set the content type for the page.',
						'contenttitle' 			=> 'You must input a title for the article.',
						'contentkeywords' 		=> 'You must input some meta keywords for the page.',
						'contentdescription' 	=> 'You must input the meta description for the page.'
						);



public function __construct()
	{
	parent::__construct();
	}

public function id()
	{
	$this->value = $this->uri->segment(1)!='ajax' && $this->uri->segment(4) ? $this->uri->segment(4) : $this->value;
	
	$this->value = isset($this->admin->postdata[$this->index]) ? $this->admin->postdata[$this->index] : $this->value;
	}

public function search()
	{
	$this->admin->model('search');
	
	// Page View and Title
	$this->admin->view = 'search/listing';	 // search/listing | search/gallery
	$this->admin->title = $this->name.' Listing';
	
	// Options and Settings
	$this->search->no_results = 'Sorry but no content items match your search. Please try searching again or search by a different field.';
	$this->search->no_records = 'No content items have been setup in the system yet.';
	
	$this->search->column('contentactive', 'Active', '1', 'switcher');
	$this->search->column('contentnodel', 'Order', '1', 'ordering', '', array('display' => 'contentorder', 'check' => 'pcoid', 'indent' => 'contentorder', 'exploder' => '.'));
	$this->search->column('contenttitle', 'Title', '3', 'text', 'N/A');
	$this->search->column('parenttitle', 'Parent', '3', 'text', 'N/A');
	$this->search->column('contentcreated', 'Created', '2', 'date', 'N/A');
	$this->search->column('contentedited', 'Edited', '2', 'date', 'N/A');
	
	//////////////////////////////////////////
	// Common Settings
	$this->search->table		= $this->table;
	$this->search->index 		= $this->index;
	$this->search->session 		= $this->table;
	$this->search->base 		= $this->base;
	$this->search->link 		= $this->link;
	
	$this->search->selectraw	= $this->select;
	$this->search->joins 		= $this->join;
	$this->search->alias 		= $this->alias;
	
	$this->search->options 		= $this->options;
	
	$this->search->filterby 	= $this->filterby;
	$this->search->filterlbl 	= $this->filterlbl;
	$this->search->filters 		= $this->filters;
	$this->search->fixedfilters = $this->fixed;
	
	$this->search->orderby 		= $this->orderby;
	$this->search->ordering 	= $this->ordering;
	
	// Run the Search
	$this->search->run();
	
	if($this->admin->inline==1)
		{
		$views = $this->search->inline();
		
		$this->admin->success('Search processed.');
		$this->admin->response(array('head' => $views['head'], 'list' => $views['list'], 'foot' => $views['foot']));
		
		$this->admin->respond();
		}
	}

public function get()
	{
	// Set the ID
	$this->id();
	
	if($this->value!='')
		{
		// Get the Record
		$this->admin->record 	= $this->db->select('content.*, p.contenttitle as parentarticle')->where('content.coid', $this->value)->join('content AS p', 'p.coid = content.pcoid', 'left')->get($this->table)->row_array();
		
		//echo '<pre>';die(print_r($this->admin->record));
		
		if($this->admin->record['contentelements']!='')
			{
			$l = json_decode($this->admin->record['contentelements']);
			$this->admin->record['contentelements'] = (array)$l;
			}
		
		$this->admin->record['contentcreated'] = date('jS M, Y', strtotime($this->admin->record['contentcreated']));
		$this->admin->record['contentedited'] = date('jS M, Y');
		}
	
	$this->admin->inline = 1;
	$this->admin->images('content');
	$this->admin->opts['photolist'] = $this->admin->imglist;
	
	$this->types();
	$this->schemas();
	$this->elements();
	// Set Page View and Title
	$this->admin->view 		= $this->editor;
	$this->admin->title 	= $this->name.' Editor';
	}

public function save()
	{
	$this->id();
	
	$this->admin->required = $this->required;
	
	$this->admin->validate();
	
	if(!isset($this->admin->response['error']))
		{
		$this->existing();
		
		//die(print_r($this->admin->postdata).print_r($this->record));
		
		$this->admin->model('webpages/urls');
		
		$this->admin->model('webpages/hierarchy');
		
		$this->sbids = isset($this->admin->postdata['sbids']) ? $this->admin->postdata['sbids'] : array();
		
		//$this->admin->postdata['contentedited'] 	= date('Y-m-d', strtotime($this->admin->postdata['contentedited']));
		
		$this->admin->postdata['contenteditor'] = $this->shake->user['id'];
		
		$this->admin->postdata['contentphoto'] = str_replace('/_media/content/', '', $this->admin->postdata['contentphoto']);
		
		$this->admin->postdata['contentimportance'] = $this->admin->postdata['contentimportance']=='' ? 1 : $this->admin->postdata['contentimportance'];
		
		if(isset($this->admin->postdata['contentelements']))
			{
			$this->admin->postdata['contentelements'] = json_encode($this->admin->postdata['contentelements']);	
			}
		else
			{
			$this->types();
			
			// Check for a default
			$this->admin->postdata['contentelements'] = isset($this->contenttypes[$this->admin->postdata['contenttype']]['contenttypedefault']) ? $this->contenttypes[$this->admin->postdata['contenttype']]['contenttypedefault'] : '';
			}
		
		unset($this->admin->postdata['filetitle'], $this->admin->postdata['parentarticle'], $this->admin->postdata['pageelements']);
		
		$this->hierarchy->set();
		
		$this->urls->clean();
		
		$this->admin->postdata['contentedited'] 	= date('Y-m-d');
		
		if($this->value!='')
			{
			if($this->db->update($this->table, $this->admin->postdata, array($this->index => $this->value)))
				{
				$this->admin->success('The '.strtolower($this->name).' has been updated.');
				//$this->admin->response(array('realorder' => $this->admin->postdata['contentrealorder']));
				}
			else
				{
				$this->admin->error('Sorry but there was an error updating the '.strtolower($this->name).'.');	
				}
			}
		else
			{
			$this->admin->postdata['contentcreated'] 	= date('Y-m-d');
			$this->admin->postdata['contentcreator'] 	= $this->admin->postdata['contenteditor'];
			
			if($this->db->insert($this->table, $this->admin->postdata))
				{
				$this->value = $this->db->insert_id();
				
				if(!isset($this->admin->response['error']))
					{
					$this->admin->success('The '.strtolower($this->name).' has been created.', $this->value);
					$this->admin->response(array('realorder' => $this->admin->postdata['contentrealorder']));
					}
				}
			else
				{
				$this->admin->error('Sorry but there was an error creating the '.strtolower($this->name).'.');		
				}
			}
		}
	
	$this->admin->respond();
	}

private function existing()
	{
	if($this->admin->postdata[$this->index]!='')
		{
		$this->record 	= $this->db->where($this->index, $this->value)->get($this->table)->row_array();
		}
	}

public function upload()
	{
	$this->admin->model('media');	
	
	$this->media->folder = 'content';
	$this->media->randomname = FALSE;
	$this->media->overwrite = TRUE;
	$this->media->setname = $this->admin->postdata['contenttitlecurl'];
	
	$this->media->upload();
	
	if(!isset($this->admin->response['error']))
		{
		$q = $this->db->where('coid', $this->admin->postdata['coid'])->get('content')->row_array();
	
		$this->media->remove($q['contentphoto']);
		
		if($this->db->update('content', array('contentphoto' => $this->media->fileinfo['file_name']), array('coid' => $this->admin->postdata['coid'])))
			{
			$msg 	= isset($this->media->resizeerr) && $this->media->resizeerr!='' 
					? 'The picture has been uploaded and the content items has been updated however there was an error creating the thumbnail.' 
					: 'The picture has been uploaded, a thumbnail created and the content items has been updated.';
			
			$this->admin->success($msg);
			$this->admin->response(array('filename' => $this->media->fileinfo['file_name'], 'fullpath' => $this->admin->mediaurl.'content/'.$this->media->fileinfo['file_name']));
			}
		else
			{
			$this->media->remove($this->media->fileinfo['file_name']);
			$this->admin->error('The picture was uploaded however there was an error updating the database.<br />The picture and thumbnail have been removed from the server.<br />Please try uploading the picture again.');
			}
		}
	
	$this->admin->respond();
	}

public function remove()
	{
	$this->admin->required = array(	'id' => 'The id for the content items is missing.',
									'filename' => 'The file name is missing.'
									);
	
	$this->admin->validate();
	
	if(!isset($this->admin->response['error']))
		{
		$this->load->model('media');
		
		$this->media->folder = 'content';
		
		$this->media->remove($this->admin->postdata['filename']);
		
		if(isset($this->media->removal['error']))
			{
			$this->admin->error('Sorry but an error occurred while trying to remove the content item photo.');	
			}
		else
			{
			if($this->db->update('content', array('contentphoto' => ''), array('coid' => $this->admin->postdata['id'])))
				{
				$this->admin->success('The content picture has been removed and the database has been updated.');	
				}
			else
				{
				$this->admin->error('The content picture was removed however there was an error updating the database. Uploading a new picture should resolve the issue.');	
				}
			}
		}
	
	$this->admin->respond();
	}


public function delete()
	{
	
	}

public function autocomplete()
	{
	$r = $this->db	->select('content.*, p.contenttitle as parenttitle')
					->join('content AS p', 'p.coid = content.pcoid', 'left')
					->like('content.contenttitle', $this->admin->postdata['term'])
					->get('content')->result_array();
	
	$l = array();
	
	if(!empty($r))
		{
		foreach($r as $a)
			{
			$t = $a['parenttitle']!='' ? $a['parenttitle'].' - '.$a['contenttitle'] : $a['contenttitle'];
			
			$l[] = array(	'id' => $a['coid'],
							'label' => $t,
							'value' => $a['contenttitle']							
							);	
			}
		}
	
	!empty($l) > 0 ? $this->admin->response($l)	: $this->admin->error('No results found.');
	
	$this->admin->respond();
	}

// Private Functions

private function schemas()
	{
	$q = $this->db->order_by('schemaorder')->get('schemas')->result_array();
	
	foreach($q as $r)
		{
		$this->admin->opts['schemas'][$r['sctid']] = stripslashes($r['schematype']);	
		}
	}

private function elements()
	{
	$i = array('index.php', 'index', '.htaccess', '_notes', 'error');
	
	$this->load->helper('directory');
	
	$v = directory_map($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->admin->site['sitetheme'].'/views/elements/', 2);
	
	foreach($v as $k => $f)
		{
		
		if(is_array($f))
			{
			$kc = str_replace('/', '', $k);
			
			foreach($f as $s)
				{
				if(!in_array($s, $i))
					{
					$sc = str_replace('.php', '', $s);
					$this->admin->opts['pageelements'][$k.$sc] = ucfirst($kc).' - '.ucfirst($sc);	
					}
				}
			}
		elseif(!in_array($f, $i))
			{
			$fc = str_replace('.php', '', $f);
			
			$this->admin->opts['pageelements'][$fc] = ucfirst($fc);
			}
		}
	
	asort($this->admin->opts['pageelements']);
	
	//echo '<pre>';die(print_r($v).print_r($this->admin->record['pageelements']));
	}
	
private function types()
	{
	$types = $this->db->order_by('contenttypeunique, contenttypetitle')->get('contenttypes')->result_array();;
	
	if(!empty($types))
		{
		foreach($types as $type)
			{
			$page = $type['ctid'];
			$this->contenttypes[$page] = $type;
			$this->admin->opts['contenttypes'][$page] = $type['contenttypeunique']==1 ? $type['contenttypetitle'].' [Unique]' : $type['contenttypetitle'];	
			}
		}
	}


}