<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Redirects extends CI_Model {

// Variables
var $usid 		= '';
var $value		= '';

// Listing and Editing URLs
var $name		= 'Redirect';
var $base 		= 'redirect/listing/';
var $link 		= 'redirect/edit/';

// Edit Folder Name
var $editor 	= 'redirect/edit';

// Table Settings
var $table 		= 'redirects';
var $index 		= 'rdid';

var $select		= 'redirects.*, content.contenttitle';

var $join		= array('content' => 'coid');

var $filterby 	= 'useractive';
var $filterlbl 	= 'Status';
var $filters	= array('1' => 'Active', '2' => 'Inactive');
var $fixed		= array();

var $orderby 	= 'redirectfrom';
var $ordering 	= 'asc';

var $searchopts	= array('redirectfrom' => 'Old URL', 'contenttitle' => 'Webpage');

// Required Fields

var $required 	= array('redirectfrom'	=> 'You must enter the old URL.',
						'coid' => 'You must select a new page that the URL should redirect to.',
						
						);

// Email Processing Variables
var $emailsub	= '';
var $emailto	= '';
var $emailtpl	= '';
var $emailsent 	= '';
var $emailfail	= '';



public function __construct()
	{
	parent::__construct();
	}

public function id()
	{
	$this->value = $this->uri->segment(1)!='ajax' && $this->uri->segment(4) ? $this->uri->segment(4) : $this->value;
	
	$this->value = isset($this->admin->postdata[$this->index]) ? $this->admin->postdata[$this->index] : $this->value;
	}

public function search()
	{
	$this->admin->model('search');
	
	// Page View and Title
	$this->admin->view 	= 'search/listing'; // search/listing | search/gallery
	$this->admin->title = $this->name.' Listing';
	
	// Set Common Settings
	$this->search->table		= $this->table;
	$this->search->index 		= $this->index;
	$this->search->session 		= $this->table;
	$this->search->base 		= $this->base;
	$this->search->link 		= $this->link;
	$this->search->process		= strtolower($this->name);
	
	$this->search->select 		= $this->select;
	$this->search->joins 		= $this->join;
	
	$this->search->options 		= $this->searchopts;
	
	$this->search->filterby 	= $this->filterby;
	$this->search->filterlbl 	= $this->filterlbl;
	$this->search->filters 		= $this->filters;
	
	$this->search->orderby 		= $this->orderby;
	$this->search->ordering 	= $this->ordering;
	
	$this->search->no_results = 'Sorry but no redirects matched your search. Please try searching again or search by a different field.';
	$this->search->no_records = 'No redirects have been setup in the system yet.';
	
	$this->search->column('redirectactive', 'Active', '1', 'switcher');
	$this->search->column('redirectfrom', 'Old URL', '5', 'text');
	$this->search->column('contenttitle', 'Redirects To', '6', 'text');
	
	// Run the Search
	$this->search->run();
	
	if($this->admin->inline==1)
		{
		$views = $this->search->inline();
		
		$this->admin->success('Search processed.');
		$this->admin->response(array('head' => $views['head'], 'list' => $views['list'], 'foot' => $views['foot']));
		
		$this->admin->respond();
		}
	}

public function get()
	{
	$this->id();
	
	if($this->value!='')
		{
		// Get the Record
		$this->admin->record 	= $this->db->where($this->index, $this->value)->join('content', 'content.coid = redirects.coid', 'left')->get($this->table)->row_array();
		}
	
	unset($this->admin->record['userpassword']);
	
	// Set Page View and Title
	$this->admin->view 		= $this->editor;
	$this->admin->title 	= $this->name.' Editor';
	}

public function save()
	{
	$this->id();
	
	$this->admin->required($this->required)
				->validate();
	
	if(!isset($this->admin->response['error']))
		{
		unset($this->admin->postdata['contenttitle']);
		
		if($this->value!='')
			{
			$this->db->update($this->table, $this->admin->postdata, array($this->index => $this->value)) 
				? $this->admin->success('The redirect has been updated.')
				: $this->admin->error('There was an error updating the redirect profile.');
			}
		else
			{
			$this->admin->postdata['redirectcreated'] = date('Y-m-d');
			
			$this->db->insert($this->table, $this->admin->postdata)
				? $this->admin->success('The redirect has been created.', $this->db->insert_id())
				: $this->admin->error('Sorry but there was an error creating the redirect.');
			}
		}
	
	$this->admin->respond();
	}


}