<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Buttons extends CI_Model {

// Variables
var $btid 		= '';
var $value		= '';
var $pages		= array();

// Listing and Editing URLs
var $name		= 'Button';
var $base 		= 'button/listing/';
var $link 		= 'button/edit/';

// Edit Folder Name
var $editor 	= 'button/edit';

// Table Settings
var $table 		= 'buttons';
var $index 		= 'btid';

var $select		= 'buttons.*, content.contenttitle';

var $join		= array('content' => 'coid');

var $filterby 	= 'buttonactive';
var $filterlbl 	= 'Status';
var $filters	= array('1' => 'Active', '2' => 'Inactive');

var $orderby 	= 'buttonorder';
var $ordering 	= 'asc';

var $options	= array('buttontitle' => 'Title', 'contenttitle' => 'Page');

// Upload Settings
var $imgfolder 	= 'buttons';
var $fieldname 	= 'fileupload';
var $allowed 	= 'png|jpg|gif';


// Class Specific Variables

// Button type list. Each of these needs to have a style created in the public site to correspond to the item
var $buttontypelist 	= array(	'homebtnvlight' => 'Home Page Button (Very Light / Default Blue)',
									'homebtnlight' => 'Home Page Button (Light)',
									'homebtnmid' => 'Home Page Button (Mid Blue)',
									'homebtndark' => 'Home Page Button (Dark Blue)',
									'homebtnvdark' => 'Home Page Button (Very Dark Blue / Site BG)',
									'homebtnimgonly' => 'Home Page Button (Image Only)',
									'homebtntxtonly' => 'Home Page Button (Text Only)',
									
									'servicebtnvlight' => 'Article Side Button (Very Light / Default Blue)',
									'servicebtnlight' => 'Article Side Button (Light)',
									'servicebtnmid' => 'Article Side Button (Mid Blue)',
									'servicebtndark' => 'Article Side Button (Dark Blue)',
									'servicebtnvdark' => 'Article Side Button (Very Dark Blue / Site BG)',
									'servicebtnimgonly' => 'Article Side Button (Image Only)',
									'servicebtntxtonly' => 'Article Side Button (Text Only)'
									);




public function __construct()
	{
	parent::__construct();
	}

public function id()
	{
	$this->value = $this->uri->segment(4) ? $this->uri->segment(4) : $this->value;
	$this->value = isset($this->admin->postdata[$this->index]) && $this->admin->postdata[$this->index]!='' ? $this->admin->postdata[$this->index] : $this->value;	
	}

public function search()
	{
	$this->admin->model('search');
	
	// Page View and Title
	$this->admin->view 	= 'search/gallery'; // search/listing | search/gallery
	$this->admin->title = $this->name.' Listing';
	
	// Set Common Settings
	$this->search->table		= $this->table;
	$this->search->index 		= $this->index;
	$this->search->session 		= $this->table;
	$this->search->base 		= $this->base;
	$this->search->link 		= $this->link;
	
	$this->search->select 		= $this->select;
	$this->search->joins 		= $this->join;
	
	$this->search->options 		= $this->options;
	
	$this->search->filterby 	= $this->filterby;
	$this->search->filterlbl 	= $this->filterlbl;
	$this->search->filters 		= $this->filters;
	
	$this->search->orderby 		= $this->orderby;
	$this->search->ordering 	= $this->ordering;
	
	$this->search->no_results = 'Sorry but no buttons matched your search. Please try searching again or search by a different field.';
	$this->search->no_records = 'No buttons have been setup in the system yet.';
	
	$this->groups();
	
	// Results Builder	  - Field     		- Label		- Width -Type			- URL [optional]	- Options [required for certain types of columns]
	//$this->search->column('buttonimage', 	'Image', 	'0', 	'image', 		'', 				array('imagepath' => '/_media/buttons/'));
	//$this->search->column('buttonicon', 	'Icon', 	'0', 	'sysicon',		'',					array('icncls' => 'buttonimageclass'));
	$this->search->column('imageicon', 		'Icon', 	'0', 	'imgicn',		'',					array(	'image' 	=> 'buttonimage', 
																											'imagepath' => '/_media/buttons/', 
																											'icon' 		=> 'buttonicon', 
																											'icnclass' 	=> 'buttonimageclass',
																											'priority' 	=> 'buttonimgicn'
																											));
	$this->search->column('buttonorder', 	'Order', 	'1', 	'ordering');
	$this->search->column('buttonactive', 	'Status', 	'1', 	'switcher');
	$this->search->column('buttontitle', 	'Title', 	'4', 	'text');
	$this->search->column('buttonlocation', 'Group', 	'3', 	'switchlist', 	'Unknown Group', 	array('list' => $this->admin->opts['buttongroups']));
	$this->search->column('contenttitle', 	'Page', 	'3', 	'text');
	
	// Run the Search
	$this->search->run();
	
	if($this->admin->inline==1)
		{
		$page = $this->admin->page();
		
		$views = $this->search->inline();
		
		$this->admin->response = array('success' => 'Search processed.', 'head' => $views['head'], 'list' => $views['list'], 'foot' => $views['foot']);
		
		$this->output->set_content_type('application/json')->set_output(json_encode($this->admin->response));
		}
	
	//echo '<pre>';die(print_r($this->search));
	}

public function get()
	{
	$this->id();
	
	$this->admin->record = $this->db->select('buttons.*, c.contenttitle as displaypage, l.contenttitle as linkpage')->where($this->index, $this->value)->join('content c', 'c.coid = buttons.coid', 'left')->join('content l', 'l.coid = buttons.lcoid', 'left')->get('buttons')->row_array();
	
	if(isset($this->admin->record['btid']) && $this->admin->record['btid']!='')
		{
		$this->admin->record['displaypages'] = $this->db->select('content.contenttitle, content.coid')->where('btid',$this->admin->record['btid'])->join('content', 'content.coid = buttonpages.coid')->get('buttonpages')->result_array();
		}
	
	$this->admin->inline = 1;
	$this->admin->images('buttons');
	//echo '<pre>';die(print_r($this->admin->imglist));
	$this->admin->opts['buttonlist'] = $this->admin->imglist;
	$this->admin->opts['buttontypelist'] = $this->buttontypelist;
	$this->admin->record['iconselector'] = $this->admin->element('icons');	
	$this->classes();
	$this->groups();
	
	$this->admin->inline = 0;
	
	// Page View and Title
	$this->admin->view = $this->editor;
	$this->admin->title = $this->name.' Editor';
	}

public function groups()
	{
	$i = array('index.php', 'index', '.htaccess', '_notes', 'error');
	
	$this->load->helper('directory');
	
	$v = directory_map($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->admin->site['sitetheme'].'/views/elements/buttons/', 1);
	
	foreach($v as $k => $f)
		{
		if(!in_array($f, $i))
			{
			$fc = str_replace('.php', '', $f);
			
			$this->admin->opts['buttongroups'][$fc] = ucfirst($fc);
			}
		}
	
	asort($this->admin->opts['buttongroups']);
	}

public function classes()
	{
	$this->admin->record['clspckr-list'] = 	array(	
												array(
													'title' => 'Button Text',
													'field'	=> 'buttonlinkclass',
													'type'	=> 'txt',
													'pre'	=> 'btn-style-preview'
													), 
												array(
													'title' => 'Button Text Hover',
													'field'	=> 'buttonlinkclass',
													'type'	=> 'txthvr',
													'pre'	=> 'btn-style-preview'
													), 
												array(
													'title' => 'Button BG',
													'field'	=> 'buttonlinkclass',
													'type'	=> 'bg',
													'pre'	=> 'btn-style-preview'
													), 
												array(
													'title' => 'Button BG Hover',
													'field'	=> 'buttonlinkclass',
													'type'	=> 'bghvr',
													'pre'	=> 'btn-style-preview'
													), 
												
												
												array(
													'title' => 'Icon Colour',
													'field'	=> 'buttonimageclass',
													'type'	=> 'txt',
													'pre'	=> 'icn-style-preview'
													),
												array(
													'title' => 'Icon Hover Colour',
													'field'	=> 'buttonimageclass',
													'type'	=> 'txthvr',
													'pre'	=> 'icn-style-preview'
													),
												array(
													'title' => 'Icon BG',
													'field'	=> 'buttonimageclass',
													'type'	=> 'bg',
													'pre'	=> 'icn-style-preview'
													),
												array(
													'title' => 'Icon BG Hover',
													'field'	=> 'buttonimageclass',
													'type'	=> 'bghvr',
													'pre'	=> 'icn-style-preview'
													)
												);
	
	
	$this->admin->record['classpicker'] = $this->admin->element('classpicker');
	
	/*
	$this->admin->record['clspckr-widths'] = 	array(	
												array(
													'title' => 'XS Screen',
													'field'	=> 'buttonlinkclass',
													'type'	=> 'col-xs',
													'pre'	=> 'btn-style-preview'
													), 
												array(
													'title' => 'Sml Screen',
													'field'	=> 'buttonlinkclass',
													'type'	=> 'col-sm',
													'pre'	=> 'btn-style-preview'
													), 
												array(
													'title' => 'Mdm Screen',
													'field'	=> 'buttonlinkclass',
													'type'	=> 'col-md',
													'pre'	=> 'btn-style-preview'
													), 
												array(
													'title' => 'Lrg Screen',
													'field'	=> 'buttonlinkclass',
													'type'	=> 'col-lg',
													'pre'	=> 'btn-style-preview'
													)
												);
	
	*/
	$this->admin->record['clspckr-widths'] = 	array(	
												array(
													'title' => 'Mobile',
													'field'	=> 'buttonwidth',
													'type'	=> 'col-xs',
													'pre'	=> 'btn-style-preview'
													), 
												array(
													'title' => 'Desktop',
													'field'	=> 'buttonwidth',
													'type'	=> 'col-sm',
													'pre'	=> 'btn-style-preview'
													)
												);
	
	$this->admin->record['widthpicker'] = $this->admin->element('classwidths');
	
	
	if(isset($this->admin->record['btid']))
		{
		$this->admin->record['buttonlinkclasses'] = explode(' ', $this->admin->record['buttonlinkclass']);
		$this->admin->record['buttonimageclasses'] = explode(' ', $this->admin->record['buttonimageclass']);
		}
	}

public function save()
	{
	$this->id();
	
	$this->admin->required(array(	'buttontitle' 		=> 'You must give the button a title.',
									'buttonlocation'	=> 'You must assign the a location on the page.',
									));
	
	if(!isset($this->admin->postdata['buttonpages']) || empty($this->admin->postdata['buttonpages']))
		{
		$this->admin->error('You must assign the button to at least 1 page.');	
		}
	
	$this->admin->validate();
	
	if(!isset($this->admin->response['error']))
		{
		$this->pages = $this->admin->postdata['buttonpages'];
		
		$this->admin->postdata['buttonimage'] = str_replace('/_media/buttons/', '', $this->admin->postdata['buttonimage']);
		
		unset($this->admin->postdata['displaypage'], $this->admin->postdata['linkpage'], $this->admin->postdata['buttonpages'], $this->admin->postdata['filetitle']);
		
		$this->order();
		
		if($this->value!='')
			{
			if($this->db->update('buttons', $this->admin->postdata, array($this->index => $this->value)))
				{
				$this->pages();
				$this->admin->success('The button has been updated.');
				}
			else
				{
				$this->admin->error('Sorry but there was an error updating the button.');	
				}
			}
		else
			{
			if($this->db->insert('buttons', $this->admin->postdata))
				{
				$this->value = $this->db->insert_id();
				
				$this->pages();
				
				$this->admin->success('The button has been created.', 	$this->db->insert_id());
				$this->admin->response('buttonorder', $this->admin->postdata['buttonorder']);
				}
			else
				{
				$this->admin->error('Sorry but there was an error creating the button.');	
				}
			}
		}
	
	$this->output->set_content_type('application/json')->set_output(json_encode($this->admin->response));	
	}

public function pages()
	{
	$s = array();
	
	$this->db->where('btid', $this->value)->delete('buttonpages'); 
	
	foreach($this->pages as $p)
		{
		$s[] = array('btid' => $this->value, 'coid' => $p);	
		}
	
	$this->db->insert_batch('buttonpages', $s);
	}

public function upload()
	{
	$this->id();
	
	$settings = array(	'upload_path' => './_media/'.$this->imgfolder.'/',
						'allowed_types' => $this->allowed,
						);
	
	$this->load->library('upload', $settings);
	
	if($this->upload->do_upload($this->fieldname))
		{
		$this->fileinfo = $this->upload->data();
		
		$this->admin->response 	= $this->db->update('buttons', array('buttonimage' => $this->fileinfo['file_name']), array('btid' => $this->value)) 
								? array('success' => 'The button has been uploaded and saved to the database.', 'filepath' => '/_media/'.$this->imgfolder.'/'.$this->fileinfo['file_name'], 'filename' => $this->fileinfo['file_name']) 
								: array('error' => 'The file was uploaded but there was an issue updating the button. Try reloading the record and assigning the button from the file selector.');
		}
	else
		{
		$this->admin->response = array('error' => 'There was an error uploading the file.<br />'.$this->upload->display_errors());	
		}
	
	$this->output->set_content_type('application/json')->set_output(json_encode($this->admin->response));	
	}

public function delete()
	{
	
	}

public function remove()
	{
	
	$this->admin->required = array(	'id' => 'The id for the advertisement is missing.',
									'filename' => 'The file name is missing.'
									);
	
	$this->admin->validate();
	
	if(!isset($this->admin->response['error']))
		{
		$this->admin->model('media');
		
		$this->media->folder = 'buttons';
		
		$this->media->remove($this->admin->postdata['filename']);
		
		if(isset($this->media->removal['error']))
			{
			$this->admin->error($this->media->removal['error']);	
			}
		elseif(isset($this->media->removal['missing']))
			{
			$this->admin->error($this->media->removal['missing']);	
			}
		else
			{
			if($this->db->update('buttons', array('buttonimage' => ''), array('btid' => $this->admin->postdata['id'])))
				{
				$this->admin->success('The button image has been removed and the database has been updated.');	
				}
			else
				{
				$this->admin->error('The button image was removed however there was an error updating the database. Uploading a new picture should resolve the issue.');	
				}
			}
		}
	
	$this->admin->respond();
	}

private function order()
	{
	if($this->admin->postdata['buttonorder']==0 || $this->admin->postdata['buttonorder']=='')
		{
		if($this->admin->postdata['btid']=='')
			{			
			$lc = $this->db->where('coid', $this->admin->postdata['coid'])->order_by('buttonorder', 'desc')->limit(1)->get('buttons')->row_array();
			
			$this->admin->postdata['buttonorder'] = isset($lc['buttonorder']) ? $lc['buttonorder']+1 : 1;
			}
		}	
	}


}