<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Analytics extends CI_Model {

// Analytics
var $recent		= array();
var $totals		= array();
var $history	= array();
var $monthly	= array();
var $summary	= array();

var $platforms	= '';
var $robotics 	= '';
var $legend		= array();


// Devices
var $ids		= array('1' => 'Desktop',
						'2' => 'Mobile',
						'3' => 'Robot',
						'4' => 'Mob-Robot'
						);


public function __construct()
	{
	parent::__construct();
	}


public function init()
	{
	$this->archive();
	
	$this->summary();
	
	$this->history();	
	}

public function summary()
	{
	$l = $this->db->select('analytics.*, content.contenttitle')->join('content', 'content.coid = analytics.coid')->order_by('analyticstime')->get('analytics')->result_array();
	
	if(!empty($l))
		{
		$ld = $lp = $li = $lc = $lt = '';
		
		foreach($l as $a)
			{
			$d = $a['analyticsdevice'];
			$p = $a['analyticsplatform'];
			$i = $a['analyticsip'];
			$c = $a['coid'];
			$t = $a['analyticstime']; 
			$h = $a['contenttitle'];
			
			$f = $lt!='' && $d==$ld && $p==$lp && $i==$li ? $t - $lt : '0';
			
			$v = $f!='0' ? ' - '.$f.' seconds later, they opened '.$h : ' - Landed on '.$h;
			
			$this->recent[$d][$p][$i][$t] = $c.$v;
			
			$n = $this->ids[$d];
			
			$this->totals['grand'] = isset($this->totals['grand']) ? $this->totals['grand'] + 1 : 1;
			$this->totals['devices'][$n] = isset($this->totals['devices'][$n]) ? $this->totals['devices'][$n] + 1 : 1;
			$this->totals['platforms'][$p] = isset($this->totals['platforms'][$p]) ? $this->totals['platforms'][$p] + 1 : 1;
			$this->totals['ips'][$i] = isset($this->totals['ips'][$i]) ? $this->totals['ips'][$i] + 1 : 1;
			$this->totals['coid'][$c]['title'] = $h;
			$this->totals['coid'][$c]['visits'] = isset($this->totals['coid'][$c]['visits']) ? $this->totals['coid'][$c]['visits'] + 1 : 1;
			
			
			$ld = $d;
			$lp = $p;
			$li = $i;
			$lt = $t;
			}
		}
	
	/*
	--.bdr-blue {border-color:#4e6db4}
	--.bdr-lgt-blue {border-color:#337ab7}
	--.bdr-drk-blue {border-color:#3c546d}
	.bdr-vdrk-blue {border-color:#0d2045}
	.bdr-blue-grey {border-color:#2b3643}
	.bdr-grey-blue {border-color:#414a56}
	
	--.bdr-pink {border-color:#c83e6a}
	.bdr-ple-red {border-color:#c23a3a}
	--.bdr-red {border-color:#ce1d2a}
	
	--.bdr-green {border-color:#72c52e}
	--.bdr-drk-green {border-color:#42975e}
	.bdr-brg-green {border-color:#56d31f}
	
	--.bdr-yellow {border-color:#dbb728}
	--.bdr-can-yellow {border-color:#e6b42f}
	--.bdr-orange {border-color:#e6852f}
	.bdr-tan {border-color:#ecd7a0}
	*/
	
	$colours = array('#337ab7', '#e6b42f', '#72c52e', '#ce1d2a', '#3c546d', '#e6852f', '#c83e6a', '#42975e', '#dbb728', '#4e6db4');
	
	$this->platforms = '[';
	
	if(isset($this->totals['platforms']))
		{
		foreach($this->totals['platforms'] as $platform => $count)
			{
			$col = isset($colours[0]) ? $colours[0] : '';
			
			if($platform!='Unknown Platform')
				{
			
				$this->platforms .= '{value:'.$count.',label:"'.$platform.'",color:"'.$col.'"},';	
				
				$this->legend['platforms'][] = array(	'label' => $platform,
														'colour' => $col,
														);
				
				unset($colours[0]);
				
				$colours = array_values($colours);
				}
			else
				{
				$this->robotics = $count;				
				}
			}
		}
	
	
	
	$this->platforms = $this->platforms!='[' ? substr($this->platforms,0,-1).']' : '';
	
	//echo '<pre>';die(print_r($this->recent).print_r($this->totals));
	}

// Archive items from last week to keep log table size down.
public function archive()
	{
	$lastweek = array();
	$weekend = strtotime('last monday');
	
	//die(print(strtotime('last friday')));
	
	$l = $this->db->select('analytics.analyticsdevice, analytics.analyticsplatform, analytics.analyticsip, COUNT(*) AS count')->where(array('analyticstime <=' => $weekend))->group_by('analyticsdevice, analyticsplatform, analyticsip')->get('analytics')->result_array();
	
	//echo '<pre>';die(print_r($l));
	
	$u = $this->db->select('COUNT(*) AS count')->where(array('analyticstime <=' => $weekend))->group_by('analyticsip')->get('analytics')->num_rows();
	
	$p = $this->db->select('COUNT(*) AS count')->where(array('analyticstime <=' => $weekend))->group_by('analyticsplatform')->get('analytics')->num_rows();
	
	if(!empty($l))
		{
		$lastweek['WeekEnding'] = date('Y-m-d', strtotime('- 1 day', $weekend));
		$lastweek['UniqueIPs'] = $u;
		$lastweek['Platforms'] = $p;
		$lastweek['WeeklyTotal'] = 0;
		
		foreach($l as $a)
			{
			$d = $a['analyticsdevice'];
			$p = $a['analyticsplatform'];
			$i = $a['analyticsip'];
			$c = $a['count'];
			
			$n = $this->ids[$d];
			
			$lastweek['Device'][$n][$p]['Total'] = isset($lastweek['Device'][$n][$p]['Total']) ? $lastweek['Device'][$n][$p]['Total'] + $c : $c;
			$lastweek['Device'][$n][$p]['Visitors'][$i] = isset($lastweek['Device'][$n][$p]['Visitors'][$i]) ? $lastweek['Device'][$n][$p]['Visitors'][$i] + $c : $c;
			$lastweek['WeeklyTotal'] += $c;
			}
		
		$this->db->insert('analyticshistory', array('anhisweekending' => $lastweek['WeekEnding'], 'anhislog' => json_encode($lastweek)));
	
		$this->db->where(array('analyticstime <=' => $weekend))->delete('analytics');
		}
	
	
	}

public function history()
	{
	$this->history = $this->db->order_by('anhisweekending', 'desc')->limit(4)->get('analyticshistory')->result_array();
	
	$this->history = array_reverse($this->history);
	
	foreach($this->history as $k => $h)
		{
		
		$l = json_decode($h['anhislog'], true);
		
		$this->history[$k]['uniqueips'] = $l['UniqueIPs'];
		$this->history[$k]['plats'] = $l['Platforms'];	
		$this->history[$k]['visits'] = $l['WeeklyTotal'];
		
		unset($this->history[$k]['anhislog']);
		
		$this->monthly['labels'] = isset($this->monthly['labels']) ? $this->monthly['labels'].', "Ending '.date('jS M, Y', strtotime($h['anhisweekending'])).'"' : '"Ending '.date('jS M, Y', strtotime($h['anhisweekending'])).'"';
		$this->monthly['data'] = isset($this->monthly['data']) ? $this->monthly['data'].',"'.$l['WeeklyTotal'].'"' : '"'.$l['WeeklyTotal'].'"';	
		}
	
	$this->monthly['labels'] = isset($this->monthly['labels']) ? $this->monthly['labels'] : '';
	$this->monthly['data'] = isset($this->monthly['data']) ? $this->monthly['data'] : '';
	}



}
