<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
//session_start();

class Admin extends CI_Model {

// View and Global Settings
var $siteid		= '1';
var $site 		= array();
var $sitename	= '';
var $theme		= '_admin';
var $base		= 'admin/';
var $mediaurl	= '/_media/';


var $view		= '';
var $views		= array();
var $elements	= array();
var $elementary	= array();

// Page Variables
var $type		= ''; 		// Page type
var $title 		= ''; 		// Content title
var $info		= array(); 	// Content info
var $inline		= '0';
var $notabs		= '';
var $notools	= '';
var $record 	= array();
var $toolbar 	= array();
var $imglist 	= array();
var $images 	= array();
var $opts		= array();

// Construct arrays [See css() and js() functions below for building the arrays]
var $css 		= array();
var $js 		= array();

// Menus
var $menu 		= array();
var $urls 		= array();
var $coid		= '';

// User
var $user 		= array();

// Pagination
var $limit		= 12; 		// Limit
var $offset		= 0;		// Offset


// Page Form Variables
var $valid 		= '';		// Error response construct
var $required 	= array();	// Required fields array
var $postdata 	= array(); 	// Postdata (merge of post and get)
var $response 	= array();	// Response variables
var $message	= array();	// Message builder


public function __construct()
	{
	parent::__construct();
	
	$this->load->model('admin/shake');
	
	$this->load->model('admin/fields');
	
	//$this->load->helper('nicefields_helper');
	}

/**
 *	Prepare SMEWS Admin
 */ 
public function prepare()
	{
	//$this->output->enable_profiler(true);
		
	// Site Info
	$this->site();
	
	// Load the User Profile
	$this->user();
	
	// Set Postdata and User
	$this->data();
	
	// Load the menu
	$this->menu();
	
	// Load some defaults
	$this->defaults();
	}

/**
 *	Save SMEWS Global Settings
 */ 
public function save()
	{
	$this->prepare();
	
	$this->required(array(	'sitename' 	=> 'You must have a name for your website.',
							'siteurl' 	=> 'You must input the URL for your website.',
							'sitetheme' => 'You must select a theme for your website.'
							));
	
	$this->validate();
	
	if(!isset($this->response['error']))
		{	
		$this->response = $this->db->update('master', $this->postdata, array('siteid' => 1)) 
						? array('success' => 'The site settings have been updated.') 
						: array('error' => 'Sorry but there was an error updating the site settings.');
		}
	
	$this->output->set_content_type('application/json')->set_output(json_encode($this->admin->response));
	}


/**
 *	Load Site Master
 */ 
public function site()
	{
	$this->site = $this->db->where(array('siteid' => $this->siteid))->get('master')->row_array();
	
	// Define some common variables	
	$this->sitename 	= 'Admin - '.stripslashes($this->site['sitename']);
	}


/**
 *	Catch User
 */ 
public function user()
	{
	// User loading
	$this->shake->load();
	}

/**
 *	Load Admin Menu
 */ 
public function menu()
	{
	if(!in_array($this->uri->segment(1), array('ajax', 'pagination', 'autocomplete')))
		{
		// User loading
		$this->menu = $this->db->where('sectionactive', 1)->order_by('sectionorder')->get('adminsections')->result_array();
		}
	}

/**
 *	Get a Master URLs List
 */ 
public function urls()
	{
	$list = array();
	// Get root level articles first
	$part = $this->db->select('coid, pcoid, pagetype, contenttitle, contentmainmenu, contenttitlecurl')->where(array('contentactive' => 1, 'pcoid' => 0))->order_by('contentrealorder')->get('content')->result_array();
	
	if(!empty($part))
		{
		foreach($part as $art)
			{
			$coid = $art['coid'];
			
			$url = $art['pagetype']=='home' ? '/' : '/'.$art['contenttitlecurl'];
				
			$this->urls[$coid] = $url;
			}
		}
	
	// Now get all non-root articles
	$cart = $this->db->where(array('contentactive' => 1, 'pcoid !=' => 0))->order_by('contentrealorder')->get('content')->result_array();
	
	if(!empty($cart))
		{
		foreach($cart as $art)
			{
			$coid = $art['coid'];
			
			$pcoid = $art['pcoid'];
			
			if(isset($this->urls[$pcoid]))
				{
				$url = $this->urls[$pcoid].'/'.$art['contenttitlecurl'];	
				
				$this->urls[$coid] = $url;
				}
			}
		}
	}


/**
 *	Defaults Handler
 */ 

public function defaults()
	{
	
	}

/**
 *	Catch Post and Get
 */ 
public function data()
	{
	/*
	if($this->uri->segment(1)=='ajax' && $this->uri->segment('3')!='login' && $this->shake->user['id']!='1')
		{
		$this->error('Sorry but you are not allowed to edit the site.')->respond();		
		}
	*/	
	// Catch Post and Get Data
	$this->postdata = array_merge($this->input->post(), $this->input->get());
	}


/**
 *	Catch Post and Get
 */ 
public function model($model)
	{
	// Catch Post and Get Data
	$this->load->model('admin/'.$model);
	}


/**
 *	CSS and JS Include Builder
 */
public function css($k)
	{
	if(is_array($k))
		{
		foreach($k as $c)
			{
			$this->css[] = $c;	
			}
		}
	else
		{
		$this->css[] = $k;	
		}
	}

public function js($k)
	{
	if(is_array($k))
		{
		foreach($k as $c)
			{
			$this->js[] = $c;	
			}
		}
	else
		{
		$this->js[] = $k;	
		}
	}


/**
 *	Toolbar Builder
 */
public function toolbar($type, $label, $icon, $id, $url, $func)
	{
	$this->toolbar[] = array(	'type' 	=> $type,
								'label' => $label,
								'icon' => $icon,
								'id' 	=> $id,																
								'url' 	=> $url,
								'func' 	=> $func
								);
	
	}


/**
 *	Form Validation
 */
public function required($f, $m=NULL)
	{
	if(is_array($f))
		{
		foreach($f as $i => $e)
			{
			$this->required[$i] = $e;	
			}
		}
	else
		{
		$this->required[$f] = $m;
		}
	
	return $this;
	}

public function validate()
	{
	if(!empty($this->required))
		{
		foreach($this->required as $f => $m)
			{
			if(!isset($this->postdata[$f]) || $this->postdata[$f]=='')
				{
				$this->valid .= $m.'<br />';	
				}
			}
		}
	
	if($this->valid!='')
		{
		$this->error($this->valid);	
		}
	}

/**
 *	Alert Builder and JSON responder
 */ 
public function response($fld, $var=NULL)
	{
	if(is_array($fld))
		{
		$this->response = !empty($this->response) ? array_merge($this->response, $fld) : $fld;
		}
	elseif($var!=NULL)
		{
		$this->response[$fld] = $var;
		}
	
	return $this;
	}

public function success($msg, $id=NULL)
	{
	if(!isset($this->response['error']))
		{
		$this->response['success'] = isset($this->response['success']) ? $this->response['success'].'<br />'.$msg : $msg;
		
		if($id!=NULL)
			{
			$this->response['newid'] = $id;	
			}
		}
	
	return $this;
	}
	
public function error($msg)
	{
	$this->response['error'] = isset($this->response['error']) ? $this->response['error'].'<br />'.$msg : $msg;
	
	return $this;
	}

public function respond()
	{
	$this->output->set_content_type('application/json')->set_output(json_encode($this->response));	
	}


/**
 *	Editor Content
 */
public function images($path=NULL)
	{
	$this->load->helper('directory');
	
	$files = array();
	
	$folder = $path!=NULL ? $path : 'images';
	
	$files[$folder]	= directory_map('./_media/'.$folder.'/', 1);
	
	//echo '<pre>';die(print_r($files));
	
	$skips = array('_notes', '_notes/', 'index.html', 'index.php', 'tn', 'tn/', 'error_log');
	
	if(!empty($files))
		{
		foreach($files as $folder => $file)
			{
			if(!empty($file))
				{
				foreach($file as $f)
					{
					if(!in_array($f, $skips) && substr($f,-1)!='/')
						{
						$p = '/_media/'.$folder.'/'.$f;
						$this->images[] = array(	'title' => $f,
													'value' => $p
													);
						
						$this->imglist[$p] = $f;
						}
					}
				}
			}
		}
	
	if(!empty($this->imglist))
		{
		asort($this->images);
		asort($this->imglist);
		}
	
	if($this->inline=='0')
		{
		$this->output->set_content_type('application/json')->set_output(json_encode($this->images));
		}
	}

public function links()
	{
	$list = array();
	// Get root level articles first
	$part = $this->db->select('coid, pcoid, contenttype, contenttitle, contenttitlecurl')->where(array('contentactive' => 1, 'pcoid' => 0))->order_by('contentrealorder')->get('content')->result_array();
	
	if(!empty($part))
		{
		foreach($part as $art)
			{
			$url = $art['pagetype']=='home' ? '/' : '/'.$art['contenttitlecurl'];
							
			$this->urls[$art['coid']] = array(	'title' => stripslashes($art['contenttitle']),
												'value' => $url
												);
			}
		}
	
	// Now get all non-root articles
	$cart = $this->db->where(array('contentactive' => 1, 'pcoid !=' => 0))->order_by('contentrealorder')->get('content')->result_array();
	
	if(!empty($cart))
		{
		foreach($cart as $art)
			{
			$url = isset($this->urls[$art['pcoid']]) ? $this->urls[$art['pcoid']].'/'.$art['contenttitlecurl'] : '/'.$art['contenttitlecurl'];
							
			$this->urls[$art['coid']] = array(	'title' => stripslashes($art['contenttitle']),
												'value' => $url
												);
			}
		}
	
	if($this->inline=='0')
		{
		$this->output->set_content_type('application/json')->set_output(json_encode($this->urls));	
		}
	}

public function themes()
	{
	$this->load->helper('directory');
	$this->load->helper('xml');
	$folders = directory_map('./_theme', 1);
	
	$themes = array();
	
	if(!empty($folders))
		{
		foreach($folders as $folder)
			{
			$folder = substr($folder, -1)=='/' ? substr($folder, 0, -1) : $folder;
			
			if($folder!='_admin' && $folder!='index.html' && file_exists('./_theme/'.$folder.'/theme.xml'))
				{
				$data = get_object_vars(simplexml_load_file('./_theme/'.$folder.'/theme.xml'));
				
				//echo '<pre>';die(print_r($data));
				
				$themes[$folder] = $data['name'];
				
				}
			}
		}
	$this->admin->opts['themes'] = $themes;
	}

/**
 *	View Output
 */ 
public function common($view)
	{
	if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/common/'.$view.'.php'))
		{
		$this->load->view('../../'.$this->theme.'/views/common/'.$view, array());	
		}
	else
		{
		$this->load->view('common/'.$view, array());
		}
	}
	
public function view()
	{
	if($this->view=='search/listing' || $this->view=='search/gallery')
		{
		$this->views = array('search/header', $this->view, 'search/paging');
		}	
		
	if(!empty($this->views))
		{
		foreach($this->views as $view)
			{
			if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/'.$view.'.php'))
				{
				$this->load->view('../../'.$this->theme.'/views/'.$view, array());	
				}
			else
				{
				$this->load->view($view, array());	
				}
			}
		}
	elseif($this->view!='')
		{
		if(is_array($this->view))
			{
			foreach($this->view as $view)
			{
			if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/'.$view.'.php'))
				{
				$this->load->view('../../'.$this->theme.'/views/'.$view, array());	
				}
			else
				{
				$this->load->view($view, array());	
				}
			}	
			}
		else
			{
			if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/'.$this->view.'.php'))
				{
				$this->load->view('../../'.$this->theme.'/views/'.$this->view, array());	
				}
			else
				{
				$this->load->view($this->view, array());
				}
			}
		}
	
	if(!empty($this->elements))
		{
		foreach($this->elements as $element)
			{
			$this->element($element);
			}
		}
	}

public function form()
	{
	$cls = $this->admin->uri->segment(2);
	$frm = $this->admin->uri->segment(3);
	
	$this->model($cls);
	
	if(method_exists($this->$cls, 'get'))
		{
		$this->$cls->get();
		
		$out = $this->load->view($cls.'/'.$frm, array(), true);
		
		$this->success('Form loaded.');
		$this->response('form', $out);
		}
	else
		{
		$this->error('No get method found for loading records.');	
		}
	$this->respond();
	}

public function element($element)
	{
	if($this->inline==0 || $this->inline=='0')
		{
		if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/elements/'.$element.'.php'))
			{
			$this->load->view('../../'.$this->theme.'/views/elements/'.$element, array());	
			}
		else
			{
			$this->load->view('elements/'.$element, array());	
			}
		}
	else
		{
		if(file_exists($_SERVER['DOCUMENT_ROOT'].'/_theme/'.$this->theme.'/views/elements/'.$element.'.php'))
			{
			return $this->load->view('../../'.$this->theme.'/views/elements/'.$element, array(), true);	
			}
		else
			{
			return $this->load->view('elements/'.$element, array(), true);	
			}	
		}
	}


/**
 *	Output Page
 */
public function output()
	{
	//echo '<pre>';die(print_r($this));
	$this->common('header');
	
	$this->common('menu');
	
	$this->common('toolbar');
	
	$this->view();
	
	$this->common('footer');
	
	$this->common('alerts');
	}


}
